#include <cv.h>
#include <cxcore.h>
#include <highgui.h>
#include <math.h>
#include <opencv2/highgui/highgui.hpp>
#include <windows.h>

#include "kinect.h"
#include "serial-sync.h"
#include "sound.h"

using namespace std;
using namespace cv;

const int system_buf_len = 4096;
DWORD total_buff = 0;
const int num_buffers = 10;

DWORD WINAPI start_clock(const LPVOID lpParam);
DWORD WINAPI start_kinect(const LPVOID lpParam);
DWORD WINAPI stop_kinect(const LPVOID lpParam);
DWORD WINAPI start_recorder(const LPVOID lpParam);
DWORD WINAPI stop_recorder(void);
BOOL save_buffer(WAVEHDR *pWaveHdr);
BOOL stop_thread_flag = false;
BOOL stop_kinect_flag = false;
BOOL store_data = false;
HANDLE hevent;
long TIME_STAMP = 0;
FILE *sound, *logfile;
HANDLE hSerial;
long act_frame = 0;
long buff_pos = 0;

char rgb_file[20];
char log_file[20];
char dep_file[20];
char snd_file[20];
char num[4];

typedef struct {
	UINT uDevice;
	WORD wFormatTag;
	WORD nChannels;
	DWORD nSamplesPerSec;
	WORD wBitsPerSample;
} PARAMETRI;

int main(int argc, char* argv[])
{
	//prepare com port
	//HANDLE hSerial;
	//hSerial = OpenComPort4Sync();

	//create kinect data
	Kinect k("saveDP.bin", "saveRGB.avi");
	if(k.init() == 0) {
		printf("Cannot init KINECT\n");
		return 0;
	}

	//create wav format
	PARAMETRI *p      = new (PARAMETRI);
	p->nChannels      = 2;
	p->nSamplesPerSec = 96000;
	p->wBitsPerSample = 16;
	p->wFormatTag     = WAVE_FORMAT_PCM;
	p->uDevice        = WAVE_MAPPER;

	// Create event:
	hevent = CreateEvent(NULL,0,0,NULL);

	HANDLE hthread[4];
	DWORD dwID[4];

	//LOAD COUNT NUMBER FROM FILE
	int counter = 0;
	FILE *cnt = fopen("counter.txt", "r");
	if(cnt != NULL)
	{
		fscanf(cnt, "%d", &counter);
		fclose(cnt);
	}

	while(1)
	{
		act_frame = 0;
		buff_pos = 0;

		strcpy(rgb_file, "saves\\");
		if((counter / 10) > 0)
			strcat(rgb_file, "0");
		else
			strcat(rgb_file, "00");
		itoa(counter, num, 10);
		strcat(rgb_file, num);
		strcpy(dep_file, rgb_file);
		strcpy(log_file, rgb_file);
		strcpy(snd_file, rgb_file);
		strcat(rgb_file, "_rgb.avi");
		strcat(dep_file, "_dep.bin");
		strcat(log_file, "_log.txt");
		strcat(snd_file, "_snd.raw");
		

		//open input wave file
		sound = fopen(snd_file, "wb");
		logfile = fopen(log_file, "w");
		k.save.open (dep_file, ios::out | ios::binary);
		k.writer = VideoWriter(rgb_file,CV_FOURCC('D', 'I', 'V', '3'), k.g_imageMD.FPS(),cvSize(640,480),1);

		//create SOUND recording thread
		hthread[0] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&start_recorder,p,0,&dwID[0]);
		SetThreadPriority(hthread[0], THREAD_PRIORITY_TIME_CRITICAL);
		printf("Sound recording thread is ARMED...\n");
		//create KINECT recording thread
		hthread[2] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&start_kinect,&k,0,&dwID[2]);
		SetThreadPriority(hthread[0], THREAD_PRIORITY_TIME_CRITICAL);
		printf("Kinect recording thread is ARMED...\n");
		//create clock generating thread
		hthread[3] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&start_clock,&k,0,&dwID[3]);
		SetThreadPriority(hthread[3], THREAD_PRIORITY_TIME_CRITICAL);
		printf("Clock ticking...\n\n");

		printf("Press any key to START recording\n");
		system("pause");
	
		//making the rocerding
		store_data = true;

		printf("STOP recording by any key\n");
		system("pause");
		store_data = false;

		// stop the thread[0] when any key is pressed (by launching another thread[1])
		stop_thread_flag = true;
		stop_kinect_flag = true;

		//wait for threads to end
		WaitForSingleObject(hthread[0], INFINITE);
		WaitForSingleObject(hthread[2], INFINITE);

		hthread[1] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)&stop_recorder,NULL,0,&dwID[1]);
		CloseHandle(hthread[1]);
	
		//WaitForSingleObject(hthread[0],INFINITE);
		CloseHandle(hthread[0]);
		CloseHandle(hthread[2]);
		CloseHandle(hthread[3]);

		//close save file
		k.closeFile();
		fclose(sound);
		fclose(logfile);

		printf("\nAnother reading? Type 'x' to exit\n");
		if(getc(stdin) == 'x')
			break;

		stop_thread_flag = false;
		stop_kinect_flag = false;
		counter ++;
	}

	//checkout the savefile
	/*FILE *f = fopen("saves//depth.bin", "rb");
	for(int a = 0; a < 100; a++) 
	{
		fread(&TIME_STAMP, 1, sizeof(TIME_STAMP), f);
		fread(k.dp.data, 1, 480*640*2, f);

		printf("%d>\n", TIME_STAMP);
		imshow("1",k.dp);
		waitKey(0);
	}*/

	printf("threads closed! Total Buffer is: ");
	printf("%d", total_buff); printf("\n");
	system("pause");

	//STORE COUNT NUMBER TO FILE
	counter ++;
	cnt = fopen("counter.txt", "w");
	fprintf(cnt, "%d", counter);
	fclose(cnt);

	return 0;
}

DWORD WINAPI start_clock(const LPVOID lpParam) 
{
	while(1)
	{
		if(stop_kinect_flag)
			break;

		TIME_STAMP ++;

		//TIME_STAMP = GetSyncNumbFromSerial(hSerial);

		//write to logfile
		if(store_data && TIME_STAMP > 0) {
			fprintf(logfile, "%d %d %d\n", TIME_STAMP, act_frame, buff_pos);
		}

		Sleep(2);
	}

	return 0;
}

DWORD WINAPI start_kinect(const LPVOID lpParam)
{
	// Get the params:
	Kinect *k;
	k = ((Kinect*)lpParam);

	// Loop...
	XnStatus rc = XN_STATUS_OK;
	while(1)
	{
		if(stop_kinect_flag)
			break;

		//grab frame and store
		// Read a new frame
		//rc = k->g_context.WaitAnyUpdateAll();
		rc = k->g_context.WaitAndUpdateAll();
		if (rc != XN_STATUS_OK)
		{
			printf("Read failed: %s\n", xnGetStatusString(rc));
			return 0;
		}

		k->g_depth.GetMetaData(k->g_depthMD);
		k->g_image.GetMetaData(k->g_imageMD);

		k->pDepth = k->g_depthMD.Data();
		k->pImage = k->g_imageMD.Data();

		memcpy(k->im.datastart, k->pImage, 640*480*3*sizeof(char));
		memcpy(k->dp.datastart, k->pDepth, 640*480*2*sizeof(char));

		cvtColor(k->im, k->im, CV_BGR2RGB);


		if(store_data) {
			k->saveFrame(TIME_STAMP);
			act_frame ++;
		}
	}

	return 0;
}

DWORD WINAPI stop_kinect(const LPVOID lpParam)
{
	// Get the params:
	Kinect *k;
	k = ((Kinect*)lpParam);

	//stop kinect
	stop_kinect_flag = true;

	k->closeFile();
	return 0;
}


DWORD WINAPI start_recorder(const LPVOID lpParam)
{
	// Get the params:
	PARAMETRI p;
	p = *((PARAMETRI*)lpParam);

	// Define WAVEFORMATEX Structure:
	WAVEFORMATEX wf;
	wf.wFormatTag      = p.wFormatTag;
	wf.wBitsPerSample  = p.wBitsPerSample;
	wf.nChannels       = p.nChannels;
	wf.nSamplesPerSec  = p.nSamplesPerSec;
	wf.nBlockAlign     = (wf.nChannels * wf.wBitsPerSample) / 8;
	wf.nAvgBytesPerSec = (wf.nSamplesPerSec * wf.nBlockAlign);
	wf.cbSize          = 0;

	// WaveInOpen
	HWAVEIN hwi;
	if(waveInOpen(&hwi,p.uDevice,(LPWAVEFORMATEX)&wf,(DWORD)hevent,0,CALLBACK_EVENT) != MMSYSERR_NOERROR)
	{
		printf("cannot open waveIn!\n"); // return -1;
		return 0;
	}

	// Define WAVEHDR Structure:
	WAVEHDR *buff = new WAVEHDR[num_buffers];
	for (int i = 0; i<num_buffers; i++)
	{
		buff[i].lpData          = (LPSTR) malloc(system_buf_len);
		buff[i].dwBufferLength  = system_buf_len;
		buff[i].dwBytesRecorded = 0;
		buff[i].dwUser          = 0;
		buff[i].dwFlags         = 0;
		buff[i].dwLoops         = 0;

		if(waveInPrepareHeader(hwi, &buff[i], sizeof(WAVEHDR)) != MMSYSERR_NOERROR) {
			printf("waveInPrepareHedare: ERROR!\n"); // return -1;
			return 0;
		}

		if(waveInAddBuffer(hwi, &buff[i], sizeof(WAVEHDR)) != MMSYSERR_NOERROR) {
			printf("waveInAddBuffer: ERROR!\n"); // return -1;
			return 0;
		}
	}

	if(waveInStart(hwi) != MMSYSERR_NOERROR) {
		printf("waveInStart: ERROR!\n"); // return -1;
		return 0;
	}

	// Loop...
	while(1)
	{
		if(stop_thread_flag)
			break;

		// CALLBACK EVENT
		WaitForSingleObject(hevent, INFINITE);
		for (int k = 0; k<num_buffers; k++)
		{
			if(buff[k].dwFlags & WHDR_DONE)
			{
				if(store_data)
					save_buffer(&buff[k]);
				waveInAddBuffer(hwi, &buff[k], sizeof(WAVEHDR));
			}
		}
	}
	for (int u = 0; u<num_buffers; u++)
	{
		waveInUnprepareHeader(hwi, &buff[u], sizeof(WAVEHDR));
	}
	waveInClose(hwi);
	return 0;
}

BOOL save_buffer(WAVEHDR *pWaveHdr)
{
	if (stop_thread_flag)
		return false;

	//printf("Bytes recorded: "); printf("%d", pWaveHdr->dwBytesRecorded); printf("\n");
	total_buff = total_buff + pWaveHdr->dwBytesRecorded;

	//store to file???
	fwrite(pWaveHdr->lpData, 1, system_buf_len, sound);
	buff_pos ++;

	//printf(pWaveHdr->lpData);
	return true;
}

DWORD WINAPI stop_recorder(void)
{
	stop_thread_flag = true;
	return 0;
}