#include "kinect.h"

using namespace std;
using namespace cv;
using namespace xn;

//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------
#define SAMPLE_XML_PATH "SamplesConfig.xml"

Kinect::Kinect(char *name, char *name2)
{
	im = Mat(480, 640, CV_8UC3);
	dp = Mat(480, 640, CV_16U);

	frame_count = 0;

	n1 = name;
	n2 = name2;

}

int Kinect::init() {
	XnStatus rc;

	EnumerationErrors errors;
	rc = g_context.InitFromXmlFile(SAMPLE_XML_PATH, &errors);
	if (rc == XN_STATUS_NO_NODE_PRESENT)
	{
		XnChar strError[1024];
		errors.ToString(strError, 1024);
		printf("%s\n", strError);
		return 0;
	}
	else if (rc != XN_STATUS_OK)
	{
		printf("Open failed: %s\n", xnGetStatusString(rc));
		return 0;
	}

	rc = g_context.FindExistingNode(XN_NODE_TYPE_DEPTH, g_depth);
	rc = g_context.FindExistingNode(XN_NODE_TYPE_IMAGE, g_image);

	//init video
	g_image.GetMetaData(g_imageMD);

	return 1;
}

//retrieve new frame
int Kinect::capture() {
	// Read a new frame
	XnStatus rc = XN_STATUS_OK;
	rc = g_context.WaitAnyUpdateAll();
	if (rc != XN_STATUS_OK)
	{
		printf("Read failed: %s\n", xnGetStatusString(rc));
		return 0;
	}

	g_depth.GetMetaData(g_depthMD);
	g_image.GetMetaData(g_imageMD);

	pDepth = g_depthMD.Data();
	pImage = g_imageMD.Data();

	memcpy(im.datastart, pImage, 640*480*3*sizeof(char));
	memcpy(dp.datastart, pDepth, 640*480*2*sizeof(char));

	cvtColor(im, im, CV_BGR2RGB);

	//flip(im, im, 1);
	//flip(dp, dp, 1);

	frame_count ++;

	return 1;
}

int Kinect::saveFrame(long clock) {

	//save video
	writer.write(im);

	if(save.is_open()) 
	{ 
		//save.write((char*)&clock, sizeof(clock));
		save.write((char*)pDepth, (unsigned long)(640*480*2*sizeof(char)));	

		return 1;
	}

	return 0;
}

int Kinect::closeFile() {

	writer.~VideoWriter();

	if(save.is_open()) {
		save.flush();
		save.close();

		//save2.flush();
		//save2.close();
	}

	return 1;
}

Kinect::~Kinect(void) {
}