/*
								+---------------------------------+
								|                                 |
								|  ***   OpenGL 3.0 shader   ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2009  |
								|                                 |
								|           Shader3.inl           |
								|                                 |
								+---------------------------------+
*/

/**
 *	@file Shader3.inl
 *	@author -tHE SWINe-
 *	@brief OpenGL 3.0 shaders
 */

#ifndef __GL30_SHADER_INLINES_INCLUDED
#define __GL30_SHADER_INLINES_INCLUDED

/*
 *								=== CGL30_Shader ===
 */

inline void CGL30_Shader::SetParam1fv(int n_location, int n_count, const float *p_value) const
{
	glUniform1fv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam2fv(int n_location, int n_count, const float *p_value) const
{
	glUniform2fv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam3fv(int n_location, int n_count, const float *p_value) const
{
	glUniform3fv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam4fv(int n_location, int n_count, const float *p_value) const
{
	glUniform4fv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam1i(int n_location, int n_value) const
{
	glUniform1i(n_location, n_value);
}

inline void CGL30_Shader::SetParam1iv(int n_location, int n_count, const int *p_value) const
{
	glUniform1iv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam2iv(int n_location, int n_count, const int *p_value) const
{
	glUniform2iv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam3iv(int n_location, int n_count, const int *p_value) const
{
	glUniform3iv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam4iv(int n_location, int n_count, const int *p_value) const
{
	glUniform4iv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParamMatrix2fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix2fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix3fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix3fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix4fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix4fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::Bind() const
{
	glUseProgram(m_n_program_object);
}

inline void CGL30_Shader::Release() const
{
	glUseProgram(0);
}

inline void CGL30_Shader::SetParamMatrix2x3fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix2x3fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix3x2fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix3x2fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix2x4fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix2x4fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix4x2fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix4x2fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix3x4fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix3x4fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParamMatrix4x3fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix4x3fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL30_Shader::SetParam1uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform1uiv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam2uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform2uiv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam3uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform3uiv(n_location, n_count, p_value);
}

inline void CGL30_Shader::SetParam4uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform4uiv(n_location, n_count, p_value);
}

/*
 *								=== ~CGL30_Shader ===
 */

#endif //__GL30_SHADER_INLINES_INCLUDED
