/*
								+--------------------------------+
								|                                |
								|   ***  Document storage  ***   |
								|                                |
								|  Copyright  -tHE SWINe- 2010  |
								|                                |
								|         DocStorage.cpp         |
								|                                |
								+--------------------------------+
*/

#include "../../UberLame_src/NewFix.h"
#include "../../UberLame_src/CallStack.h"
#include <stdio.h>
#include "../../UberLame_src/Integer.h"
#include "../../UberLame_src/StlUtils.h"
#include "DocStorage.h"

#if defined(_MSC_VER) && !defined(__MWERKS__) && !defined(for)
#define for if(0) {} else for
#endif

/*
 *								=== TDocument ===
 */

bool TDocument::Read(std::vector<std::basic_string<wchar_t> > &r_terms,
	std::vector<TDocument> &r_documents, const char *p_s_infile)
{
	r_documents.clear();
	r_terms.clear();

	FILE *p_fr;
	if(!(p_fr = fopen(p_s_infile, "rb")))
		return false;
	// open input file

	uint32_t n_file_magic, n_term_num, n_document_num;
	if(fread(&n_file_magic, sizeof(uint32_t), 1, p_fr) != 1 ||
	   fread(&n_term_num, sizeof(uint32_t), 1, p_fr) != 1 ||
	   fread(&n_document_num, sizeof(uint32_t), 1, p_fr) != 1) {
		fclose(p_fr);
		return false;
	}
	// read file header

	if(n_file_magic != 0xbaadf00dU) { // bad food
		fclose(p_fr);
		return false;
	}
	// check magic number

	if(!stl_ut::Resize_To_N(r_documents, n_document_num) ||
	   !stl_ut::Resize_To_N(r_terms, n_term_num))
		return false;
	// allocate lists of terms and documents

	for(uint32_t i = 0; i < n_term_num; ++ i) {
		if(!ReadWString(r_terms[i], p_fr)) {
			fclose(p_fr);
			return false;
		}
	}
	// read terms

	for(uint32_t i = 0; i < n_document_num; ++ i) {
		if(!r_documents[i].Read(p_fr)) {
			fclose(p_fr);
			return false;
		}
	}
	// read documents

	long n_pos = ftell(p_fr);
	fseek(p_fr, 0, SEEK_END);
	if(n_pos != ftell(p_fr)) {
		fclose(p_fr);
		return false;
	}
	// make sure whole file was read (otherwise there might be errors)

	fclose(p_fr);
	// close input file

	return true;
}

bool TDocument::ReadWString(std::basic_string<wchar_t> &r_s_dest, FILE *p_fr)
{
	uint32_t n_length;
	return fread(&n_length, sizeof(uint32_t), 1, p_fr) == 1 &&
		stl_ut::Resize_To_N(r_s_dest, n_length) &&
		fread(&r_s_dest[0], sizeof(wchar_t), n_length, p_fr) == n_length;
}

bool TDocument::Read(FILE *p_fr)
{
	term_frequency_map.clear();
	term_position_list.clear();

	uint32_t n_document_magic;
	uint32_t n_word_num, n_document_length;

	if(fread(&n_document_magic, sizeof(int32_t), 1, p_fr) != 1 ||
	   fread(&n_word_num, sizeof(int32_t), 1, p_fr) != 1 ||
	   fread(&n_document_length, sizeof(int32_t), 1, p_fr) != 1 ||
	   !ReadWString(s_name, p_fr) || !ReadWString(s_date, p_fr))
		return false;
	// read document header

	if(n_document_magic != 0xd00cd00cU) // doc doc
		return false;
	// check magic number

	try {
		for(uint32_t i = 0; i < n_word_num; ++ i) {
			uint32_t n_frequency, n_global_term_id;
			
			if(fread(&n_global_term_id, sizeof(int32_t), 1, p_fr) != 1 ||
			   fread(&n_frequency, sizeof(int32_t), 1, p_fr) != 1)
				return false;

			_ASSERTE(n_global_term_id <= SIZE_MAX);
			_ASSERTE(n_frequency <= SIZE_MAX);
			_ASSERTE(term_frequency_map.find(n_global_term_id) == term_frequency_map.end());
			term_frequency_map.insert(std::map<size_t, size_t>::value_type(size_t(n_global_term_id), size_t(n_frequency)));
		}
	} catch(std::bad_alloc&) {
		return false;
	}
	// read term frequencies

	if(!stl_ut::Resize_To_N(term_position_list, n_document_length))
		return false;
	for(uint32_t i = 0; i < n_document_length; ++ i) {
		uint32_t n_global_term_id;
		if(fread(&n_global_term_id, sizeof(int32_t), 1, p_fr) != 1)
			return false;
		_ASSERTE(n_global_term_id <= SIZE_MAX);
		term_position_list[i] = n_global_term_id;
	}
	// read term positions

	return true;
}

/*
 *								=== ~TDocument ===
 */
