#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>
#include <iostream>
#include <fstream>

#include <opencv2/objdetect/objdetect.hpp>
#include <opencv2/features2d/features2d.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/calib3d/calib3d.hpp>
#include <opencv2/imgproc/imgproc_c.h>

#include "camera_kalman.h"
#include "cam.h"
#include "PointObserver.h"

#include <glut.h>

using namespace std;
using namespace cv;

//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------
float fov=45.0;                                 /* zorny uhel - field of view */
float near_plane=1;                             /* blizsi orezavaci rovina */
float far_plane=1000.0;                         /* vzdalenejsi orezavaci rovina */
int   WindowWidth;                              /* sirka a vyska okna */
int   WindowHeight;

int   xnew=0, ynew=0, znew=0;                   /* soucasna pozice, ze ktere se pocitaji rotace a posuny */
int   xold=0, yold=0, zold=0;                   /* minula pozice, ze ktere se pocitaji rotace a posuny */
int   xx1=0, yy1=0, zz1=0;                      /* body, ve kterych se nachazi kurzor mysi */
int   stav=0;                                   /* stav tlacitek mysi */
static int modifiers;				/* mod flags */
bool capture = true;
bool scan = true;
bool show = true;

float lX = -1, lY = -1, lZ = -1;
ofstream myfile;

//video writer
VideoWriter writer;
//virtual camera
Mat D;	//distortion coeffs
Mat A;	//camera matrix
Mat R;	//camera rotation
Mat T;	//camera translation


// -------------------- GLOBALS -------------------- //
//load video streams
VideoCapture img, dpt;
//corner extraction
PointObserver po(50);
int keyframe = 500; //every keyframe do matching again
int counter = 0;
Mat un_image, g_image, un_depth, last, draw, image, depth, prj, doub;
vector<Point3f> pmap;
vector<Point3f> pcol;


void Init(void) 
{
	glClearColor(0.0, 0.0, 0.0, 0.0);             /* barva pro mazani color-bufferu */
	glShadeModel(GL_SMOOTH);                      /* nastaveni stinovaciho rezimu */
	glClearDepth(1.0f);                           /* barva pro mazani z-bufferu */
	glEnable(GL_DEPTH_TEST);                      /* nastaveni funkce pro testovani hodnot v z-bufferu */
	glDepthFunc(GL_LESS);                         /* kterou funkci vybrat */
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST); /* vylepseni zobrazovani */
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);    /* nastaveni vykresleni vyplnenych polygonu */
	     
	glPointSize(2.0);                             /* velikost vykreslovanych bodu */
	glEnable(GL_POINT_SMOOTH);                    /* povoleni antialiasingu bodu */
	glLineWidth(0.5);                             /* sirka vykreslovanych car */
	glEnable(GL_LINE_SMOOTH);    

	myfile.open ("example.txt");

	//writer=VideoWriter("out.avi",-1,
      //                     25,cvSize(640,960),1);
	D = Mat::zeros(5, 1, CV_64F);
	A = Mat::zeros(3, 3, CV_64F);
	R = Mat::zeros(3, 1, CV_64F);
	T = Mat::zeros(3, 1, CV_64F);
	A.at<double>(0, 0) = 500; A.at<double>(1, 1) = 500;
	A.at<double>(0, 2) = 320; A.at<double>(1, 2) = 240;
	T.at<double>(0, 0) = 10; T.at<double>(2, 0) = 30;
	prj.create(480, 640, CV_8UC3);
	doub.create(960, 640, CV_8UC3);

}

void onReshape(int w, int h)
{
  glViewport(0, 0, w, h);                       /* viditelna oblast */
  glMatrixMode(GL_PROJECTION);                  /* projekcni matice */
  glLoadIdentity();			                    /* nahrat jednotkovou matici */
  gluPerspective(fov, (double)w/(double)h, near_plane, far_plane);
  glMatrixMode(GL_MODELVIEW);                   /* modelova matice */
  WindowWidth = w;                              /* ulozeni rozmeru okna */
  WindowHeight = h;
}

void onMouseClick(int button, int state, int x, int y)
{
	modifiers = glutGetModifiers();
	if (button == GLUT_LEFT_BUTTON) {             /* leve tlacitko aktivuje rotaci */
		if (state == GLUT_DOWN) {                   /* pri stlaceni */
			stav = 1;                                 /* nastaveni pro funkci motion */
			xx1 = x;                                  /* zapamatovat pozici kurzoru mysi */
			yy1 = y;
		} else {                                    /* GLUT_UP */
			stav = 0;                                 /* normalni stav */
			xold = xnew;                              /* zapamatovat novy pocatek */
			yold = ynew;
		}
	}
	if (button == GLUT_RIGHT_BUTTON) {            /* prave tlacitko aktivuje posun */
		if (state == GLUT_DOWN) {                   /* pri stlaceni */
			stav = 2;                                 /* nastaveni pro funkci motion */
			zz1 = y;                                  /* zapamatovat pozici kurzoru mysi */
		}
		else {
			stav = 0;
			zold = znew;                              /* zapamatovat novy pocatek */
			
		}
	}
	glutPostRedisplay();                          /* prekresleni sceny */
}

void onMouseMotion(int x, int y) {
	if (stav == 1) {                              /* stav presunu */
		xnew = xold+x-xx1;                          /* vypocitat novou pozici */
		ynew = yold+y-yy1;
		glutPostRedisplay();                        /* a prekreslit scenu */
		//and compute new material
	} else if (stav == 2) {                              /* stav presunu */
		znew = zold+y-zz1;                          /* vypocitat novou pozici */
		glutPostRedisplay();                        /* a prekreslit scenu */
	} 
	glutPostRedisplay();
}

void glutIdle (void)
{
	// Display the frame
	glutPostRedisplay();
}

int processFrame() {
	if(!img.isOpened() || !dpt.isOpened()) 
	{
		printf("Could not grab a frame\n\7");
		return 0;
	}
	printf("-----\n");
	img >> image;
	dpt >> depth;
	//test emptyness
	if(image.empty() || depth.empty()) {
		//end writing
		po.write.close();
		printf("file closed\n");

		return 0;
	}
	printf("1\n");

	flip(image, image, 1);
	flip(depth, depth, 1);
	//undistort images
	undistort(image, un_image, po.cam_A, po.cam_D, po.cam_A);
	undistort(depth, un_depth, po.dep_A, po.dep_D, po.dep_A);
	printf("flipped\n");	

	cvtColor(un_image, g_image, CV_RGB2GRAY);

	//track points
	//po.trackPoints(g_image);

	po.trackPoints(g_image, un_depth, keyframe);
	printf("treacked\n");

	/*cout << po.cam_T2.at<double>(0, 0) << " " << po.cam_T2.at<double>(1, 0) << " " << po.cam_T2.at<double>(2, 0) << "\n"; 
	cout << po.cam_R.at<double>(0, 0) << " " << po.cam_R.at<double>(1, 0) << " " << po.cam_R.at<double>(2, 0) << "\n"; */

	int cnt = 0;
	if(!po.keys2.empty()) 
	{
		//draw
		for(int a = 0; a < po.keys2.size(); a++) 
		{
			if(po.state3D[a] == 1) {
				circle(un_image, po.keys[a].pt, 1, CV_RGB(255, 0, 0), 3, 8, 0);
				line(un_image, po.keys[a].pt, po.keys2[a].pt, CV_RGB(0, 255, 0), 1, 8, 0);

				cnt ++;
			}
		}
	}
	//printf("Features: %d, Matched: %d\n", po.keys.size(), cnt);

	/*if(lX != -1) 
	{
		float mov = sqrt((lX - po.cam_T2.at<double>(0, 0)) * (lX - po.cam_T2.at<double>(0, 0)) +
			(lY - po.cam_T2.at<double>(1, 0)) * (lY - po.cam_T2.at<double>(1, 0)) +
			(lZ - po.cam_T2.at<double>(2, 0)) * (lZ - po.cam_T2.at<double>(2, 0)));
		myfile << mov << "\n";
	}*/

	lX = po.cam_T2.at<double>(0, 0);
	lY = po.cam_T2.at<double>(1, 0);
	lZ = po.cam_T2.at<double>(2, 0);

	printf("drawn\n");

	image.copyTo(last);
	imshow("win", un_image);
	
	//counter
	/*counter ++;
	if(counter % 15 == 0)
		scan = true;*/

	// write to file
	po.write << po.frame << " " << po.keys.size() << " " << "\n";
	for(int a = 0; a < po.keys.size(); a++) {
		po.write << po.keyID[a] << " " << po.keys3D[a].x << " " << po.keys3D[a].y << " " << po.keys3D[a].z << " " << 
			po.keys[a].pt.x << " " << po.keys[a].pt.y << "\n";
	}

	po.frame ++;

	return 1;
}

void render() 
{
	glTranslatef(0.0f, 0.0f, -20.0f);             /* posun modelu dale od kamery */
	glTranslatef(0.0f, 0.0f, znew);
	glRotatef(ynew, 1.0, 0.0, 0.0);               /* rotace objektu podle pohybu kurzoru mysi */
	glRotatef(xnew, 0.0, 1.0, 0.0);

	//draw scan
	for(int a =0; a < pmap.size(); a++) 
	{
		glBegin(GL_POINTS);
		glColor3f(pcol[a].z/256, pcol[a].y/256, pcol[a].x/256); glVertex3f( pmap[a].x, -pmap[a].y, -pmap[a].z- 0.1);
		glEnd();
	}

	if(show) 
	{
	//draw
	for(int a =0; a < po.keys.size(); a++) 
	{
		if(po.state3D[a] == 1) 
		{
			glBegin(GL_POINTS);

			glColor3f(1, 0, 0); glVertex3f( po.keys3D[a].x, -po.keys3D[a].y, -po.keys3D[a].z );

			glEnd();
		}
	}
	
	//draw camera
	glPointSize(5.0);
	glBegin(GL_POINTS);
	}

	glColor3f(0, 1, 0); glVertex3f( po.cam_T2.at<double>(0, 0), po.cam_T2.at<double>(1, 0), po.cam_T2.at<double>(2, 0) );

	glEnd();
	glPointSize(2.0);
}

void glutDisplay (void)
{
	if(capture) 
	{
		processFrame();
		//capture = false;
	}
	if(scan) 
	{
		//add points to map
		int scale = 3;
		for(int a = 20; a < depth.rows-20; a+= scale)
		{
			for(int b = 20; b < depth.cols-20; b+= scale)
			{
				float rawdepth = (depth.at<Vec3b>( a , b )[0] + depth.at<Vec3b>( a , b )[1] * 256) / 100.0;
				if(rawdepth > 1)
				{
					//add
					Point3f p, c;
					Mat vect(3, 1, CV_64F);
					Mat X(3, 1, CV_64F);
					vect.at<double>(0, 0) = (b - po.cam_A.at<double>(0, 2)) * rawdepth / po.cam_A.at<double>(0, 0);
					vect.at<double>(1, 0) = (a - po.cam_A.at<double>(1, 2)) * rawdepth / po.cam_A.at<double>(1, 1);
					vect.at<double>(2, 0) = rawdepth;

					//get the point to the right coordinate frame
					Mat R(3, 3, CV_64F);
					Rodrigues(po.cam_R, R);
					invert(R, R, 0);
					Mat T(3, 1, CV_64F);
					T = R * (po.cam_T);
					X = (R * vect) - T;

					p.x = X.at<double>(0, 0);
					p.y = X.at<double>(1, 0);
					p.z = X.at<double>(2, 0);

					c.x = image.at<Vec3b>(a, b)[0];
					c.y = image.at<Vec3b>(a, b)[1];
					c.z = image.at<Vec3b>(a, b)[2];

					pmap.push_back(p);
					pcol.push_back(c);
				}
			}
		}

		scan = false;
	}

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); /* vymazani barvoveho bufferu */
	glMatrixMode(GL_MODELVIEW);                   /* bude se menit modelova matice */
	glLoadIdentity();	 	                       /* nahrat jednotkovou matici */

	glShadeModel(GL_SMOOTH);

	// draw scene
	render();
  
	glFlush();                                    /* provedeni vsech prikazu */

	glutSwapBuffers();                            /* a prohozeni bufferu */
}

void onKeyboard(unsigned char key, int x, int y)
{
	if(key == 'c')
		capture = true;
	else if(key == 's')
		scan = true;
	else if(key == 'i')
		if(show == true)
			show = false;
		else
			show = true;
}

int main(int argc, char* argv[])
{
	if(argc < 2) 
	{
		img.open("cap_rgb.avi");
		dpt.open("cap_depth.avi");
	} else {
		img.open(argv[1]);
		dpt.open(argv[2]);
	}

	//load camera matrices
	po.loadMatrix("Intrinsics_RGB.xml", po.cam_A);
	po.loadMatrix("Distortion_RGB.xml", po.cam_D);

	po.loadMatrix("Intrinsics_IR.xml", po.dep_A);
	po.loadMatrix("Distortion_IR.xml", po.dep_D);

	//skip first frame
	img >> image;
	dpt >> depth;

	/*writer=VideoWriter("out.avi",-1, 30,cvSize(640,480),1);

	while(1) 
	{
		img >> image;
		//dpt >> depth;

		if(image.empty())
			break;

		flip(image, image, 1);
		undistort(image, un_image, po.cam_A, po.cam_D, po.cam_A);
		imshow("win", un_image);
		cvWaitKey(1);

		writer.write(un_image);
	}

	writer.~VideoWriter();*/

	//GLUT INIT
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
	glutInitWindowSize(800, 600);
	glutCreateWindow ("Shower");

	glutIdleFunc(glutIdle);
	glutDisplayFunc(glutDisplay);
	glutReshapeFunc(onReshape);
	glutMouseFunc(onMouseClick);  
    glutMotionFunc(onMouseMotion);
	glutKeyboardFunc(onKeyboard);

	Init();
	glutMainLoop();

	return 0;
}