#ifndef CHESSBOARD_H_
#define CHESSBOARD_H_

#include <cv.h>

int get_chesscorners(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, int maxcount, int okno, int thresh);
//detekuje v obraze body a vraci je a uhly sachovnicovych car v okoli
// image - bud RGB nebo Grayscale
// maxcount - maximalni pocet detekovanych bodu, zaroven velikost predavanych poli
// okno - v jakem polomeru probiha test sachovosti
// thresh - threshold predavany testu sachovosti - idealne 70


void draw_chesscorners(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, int count, int size, CvScalar color);
//vykresli body danou barvou do obrazu
// image - obrazek, do ktereho se kresli
// corners - pole rohu
// uhly - odpovidajici uhly z okoli bodu
// count - pocet bodu
// size - polomer vykreslovane kruznice
// color - barva, kterou se kresli


int mean(IplImage * image, CvPoint bod, int okno);
//vypocet stredni hodnoty pres okno
// image - obraz
// bod + okno - definuji oblast v obraze, ve ktere se mean pocita

int soumernost(IplImage * image, CvPoint2D32f roh, int okno, int tresh);
//test sachovosti -  test soumernosti bodu NOT USED

int principal_angles(IplImage * image, CvPoint2D32f roh, CvScalar * ruhel, double R, int tresh);
//test sachovosti - zjisteni hlavnich os
//image - musi byt grayscale
//R  - polomer testovaci kruznice
//tresh - treshold pro zjisteni hrany

#define TEST_SOUMERNOST 1
#define TEST_PRINCIPAL 2

int test_soumernosti(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, int count, int okno, int tresh, int metoda);
// test a filtrace seznamu bodu
// doporucena hodnota okna 8, thresh 5+- -- pro soumernost, ted neni implementovano
//												 8, thresh 70  -- pro principal angles
// image - obrazek, ve kterem se provede zpracovani
// corners - pole, do ktereho se vrati detekovane body
// uhly - pole, do ktereho se vrati uhly hran v okoli bodu
// count - velikost vstupniho pole
// okno - v jakem okoli(polomer v pixelech) se prohledavaji gradienty
// thresh - prah pro zjisteni hrany
// metoda - pro TEST_SOUMERNOST se vyuzije metoda sledovani soumernosti okoli pro TEST_PRINCIPAL funkce principal_angles()

int create_test_data(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, CvSize objekt_size, CvPoint objekt_pos, int maxcount, int okno);
//detekne rohy sachovnice a doplne je o nahodne generovane outliery
// TEST PURPOSES ONLY

bool check_onlines(IplImage * image, CvPoint2D32f bod1, CvPoint2D32f bod2, int thres, int edgethres);
//kontrola, zda jsou dva body spojeny hranou
// image - obrazek v odstinech sedi - 8bit 1channel
// thres  - 0-100 - kolik procent samplu musi odpovidat hrane - idealne tak 85
// edgethresh - rozdil intenzit samplovanych bodu, ktere urci hranu - kolem 100

bool check_onlines_sobel(IplImage * image, CvPoint2D32f bod1, CvPoint2D32f bod2, int thres);
//kontrola, zda jsou dva body spojeny hranou - vyuziti Sobelova operatoru, thresh - cca 150
// NEPOUZIVA SE

void Sobel(IplImage * src, IplImage * dst);
//proste sobel, jen kvuli testovani

#endif