#include "chessboard.h"

#include <iostream>
#include "fast.h"
//#include "cvaux.h"


using namespace std;

struct usek{
	int typ;
	int stred;
	int start, stop;
} ;

struct hrana{
	bool positive;
	double uhel;
};



//pomocne funkce
inline uchar getPixel( IplImage*img, int col, int lin, int channel ) {
	//zjisti hodnotu pixelu
	return ((uchar*)(img->imageData + img->widthStep*lin))[col+channel] ;
}

inline bool inImage( IplImage*img, int x, int y) {
	//zjisti hodnotu pixelu
	return ((x>=0)&&(y>=0)&&(x<img->width)&&(y<img->height));
}


int mean(IplImage * image, CvPoint bod, int okno){
	//vypocet stredni hodnoty pixelu v danem okoli bodu
	int suma = 0;
	int pocet = 0;
	int opul = okno/2;

	if (((bod.x-opul)>=0)&&((bod.y-opul)>=0)&&((bod.x+opul)<image->width)&&((bod.y+opul)<image->height)){
		for (int i = 0; i< okno; i++){
			for (int j = 0; j< okno; j++){//forfor pres ctvrt okoli
				suma += getPixel(image, bod.x-opul+i, bod.y-opul+j, 0);
				pocet++;
			}
		}
	}
	if (pocet>0) return (suma/pocet);
	else return 0;
}//mean



int soumernost(IplImage * image, CvPoint2D32f roh, int okno, int tresh){
	//test sachovnicove soumernosti daneho bodu
	int opul = okno/2;
	double kvad[4];//kvadranty
	CvPoint roh2D = cvPointFrom32f(roh);
	uchar pixval, pixval0;

	memset(kvad, 0, sizeof(kvad));

	if ((roh2D.x>0)&&(roh2D.y>0))
		pixval0 = getPixel( image, roh2D.x, roh2D.y, 0 );

	double T = (double)(tresh);

	int stred = mean(image, roh2D, 5);

	if (((roh2D.x-opul)>0)&&((roh2D.y-opul)>0)&&((roh2D.x+opul)<image->width)&&((roh2D.y+opul)<image->height)){
		for (int i = 0; i< opul; i++){
			for (int j = 0; j< opul; j++){//forfor pres ctvrt okoli
				pixval = getPixel(image, roh2D.x-opul+i, roh2D.y-opul+j, 0);
				if (pixval>=stred) kvad[0]++;
				//kvad[0] += evalC(pixval, pixval0, T);
				//if pixval>
				pixval = getPixel(image, roh2D.x+i+1, roh2D.y-opul+j, 0);
				if (pixval>=stred) kvad[1]++;
				//kvad[1] += evalC(pixval, pixval0, T);
				pixval = getPixel(image, roh2D.x+i+1, roh2D.y+j+1, 0);
				//kvad[2] += evalC(pixval, pixval0, T);
				if (pixval>=stred) kvad[2]++;
				pixval = getPixel(image, roh2D.x-opul+i, roh2D.y+j+1, 0);
				//kvad[3] += evalC(pixval, pixval0, T);
				if (pixval>=stred) kvad[3]++;
			}
		}
		//cout << kvad[0] << " " << kvad[1] << " " << kvad[2] << " " << kvad[3] <<  " = " << ((kvad[0]+kvad[1]+kvad[2]+kvad[3])/(okno*okno)) << endl;
		if ((abs(kvad[2]-kvad[0])<tresh)&&(abs(kvad[3]-kvad[1])<tresh)&&(abs(max(kvad[2], kvad[0])-max(kvad[1], kvad[3]))>tresh))//je symetricky
			return 1;
		else return 0;
	}
	return -1;
	
}

//#define START 0
#define MON 0
#define KLES -1
#define STUP 1

int principal_angles(IplImage * image, CvPoint2D32f roh, CvScalar * ruhel, double R, int tresh){
	const int kroku = 80;
	int profil[kroku];
	double positive[kroku];
	double negative[kroku];
	const double krok = 2.0 * CV_PI/kroku;
	double uhel = 0.0;
	double t_alpha;
	int x, y, i, derivace, positive_count, negative_count, hrany_count, pixval;

	memset(ruhel, 0, sizeof(CvScalar));

	if ((R>0)&&(cvRound(roh.x-R)>=0)&&(cvRound(roh.y-R)>=0)&&(cvRound(roh.x+R)<image->width)&&(cvRound(roh.y+R)<image->height)){

		int mn = mean(image, cvPointFrom32f(roh), cvRound(R));
		for (i=0; i< kroku; i++){
			//naplneni profilu
			x = cvRound(roh.x+ R*cos(uhel));
			y = cvRound(roh.y+ R*sin(uhel));
			pixval = getPixel(image, (int)x, (int)y, 0);
			if (pixval>mn) profil[i] = 255;
			else profil[i] = 0;
			//profil[i] = pixval;
			uhel += krok;
		}//for
	
		hrany_count = positive_count = negative_count = 0;
		i=1;
		
		usek useky[kroku];
		memset(useky, 0, sizeof(useky));

		int stav;
		derivace = profil[0]-profil[kroku-1];
		int uk = 0;

		if (derivace>tresh){
			useky[uk].typ = stav = STUP;
			useky[uk].stred += derivace;
		}
		else if (derivace<-tresh){
			useky[uk].typ = stav = KLES;
			useky[uk].stred += derivace;
		}
		else
			useky[uk].typ = stav = MON;
		
		useky[uk].start = 0;
		while ((i<kroku)){
			derivace = profil[i]-profil[i-1];
			switch (stav) {
				case MON:
					if (derivace>tresh){//stoupa
						useky[uk].stop = i;
						uk++;
						useky[uk].start = i;
						useky[uk].typ = STUP;
						useky[uk].stred += derivace;
						stav = STUP;
					}
					else if (derivace<-tresh){//klesa
						useky[uk].stop = i;
						uk++;
						useky[uk].start = i;
						useky[uk].typ = KLES;
						stav = KLES;
						useky[uk].stred += derivace;
					}
					break;
				case STUP:
					if (derivace>tresh){//stoupa
						useky[uk].stred += derivace;
					}
					else if (derivace<-tresh){//klesa
						useky[uk].stop = i;
						uk++;
						useky[uk].start = i;
						useky[uk].typ = KLES;
						useky[uk].stred += derivace;
						stav = KLES;
					}
					else{
						useky[uk].stop = i;
						uk++;
						useky[uk].start = i;
						useky[uk].typ = MON;
						useky[uk].stred += derivace;
						stav = MON;
					}

					break;
					case KLES:
					if (derivace>tresh){//stoupa
						useky[uk].stop = i;
						uk++;
						useky[uk].start = i;
						useky[uk].typ = STUP;
						useky[uk].stred += derivace;
						stav = STUP;
					}
					else if (derivace<-tresh){//klesa
						useky[uk].stred += derivace;
					}
					else{
						useky[uk].stop = i;
						uk++;
						useky[uk].start = i;
						useky[uk].typ = MON;
						useky[uk].stred += derivace;
						stav = MON;
					}

					break;
				default:
					break;
			}
			i++;
		}
		useky[uk].stop = i;
		//spojeni prvniho a posledniho
		if (useky[uk].typ==useky[0].typ){
			//useky[uk].stop += useky[0].stop;
			//useky[uk].stred += useky[0].stred;
			useky[0].start -= useky[uk].stop-useky[uk].start;
			useky[0].stred += useky[uk].stred;
			uk--;
		}

		/*i = 0;
		while ((i<kroku)&&(positive_count+negative_count<4)){
			derivace = profil[i]-profil[i-1];
			if (abs(derivace)>tresh){ 
				if (derivace>0) {
					positive[positive_count] = ((double)i)*krok;
					positive_count++;
				}
				else {
					negative[negative_count] = ((double)i)*krok;
					negative_count++;
				}//else
			}//if
			i++;
		}//while*/

		memset(negative, 0, sizeof(negative));
		memset(positive, 0, sizeof(positive));

		for (i=0; i<=uk; i++){
			if (useky[i].typ==STUP) {
				positive[positive_count] = ((double)((useky[i].stop+useky[i].start)/2))*krok;
				positive_count ++;
			}
			else if (useky[i].typ==KLES) {
				negative[negative_count] = ((double)((useky[i].stop+useky[i].start)/2))*krok;
				negative_count ++;
			}
		}
		//test sechovnice
		if ((positive_count==2)&&(negative_count==2)){//asi roh sachovnice, jeste test
			 t_alpha = 1.3*asin(1.0/R);
			if ( (abs(positive[1]-positive[0]-CV_PI)<t_alpha) && (abs(negative[1]-negative[0]-CV_PI)<t_alpha)
				&&(min(abs(negative[0]-positive[0]), abs(negative[1]-positive[0]))>R*t_alpha/1.3)){
					if (negative[0]<positive[0]){
						ruhel->val[0] = negative[0];
						ruhel->val[1] = positive[0];
						ruhel->val[2] = negative[1];
						ruhel->val[3] = positive[1];
					}
					else{
						ruhel->val[0] = positive[0];
						ruhel->val[1] = negative[0];
						ruhel->val[2] = positive[1];
						ruhel->val[3] = negative[1];
					}
				return 1; 
			}
				
		}
		return 0;
	}//if
	return -1;
}

#define TEST_SOUMERNOST 1
#define TEST_PRINCIPAL 2

int test_soumernosti(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, int count, int okno, int tresh, int metoda){
	// test soumernosti pro vsechny body a jejich promazani
	CvPoint2D32f * icorners = (CvPoint2D32f*)cvAlloc(count*sizeof(CvPoint2D32f));
	memcpy(icorners, corners, count*sizeof(CvPoint2D32f));
	int pocet = 0;
	CvScalar uhel;

	if (metoda==TEST_PRINCIPAL){
		double R = (double)okno;
		for (int i=0; i<count; i++){
		//pokud splnuje podminku soumernosti, predam na vystup
			if (principal_angles(image, icorners[i], &uhel, R, tresh)==1){
			//if (soumernost(image, icorners[i], okno, tresh)==1){//je to roh sachovnice
				corners[pocet] = icorners[i];
				uhly[pocet] = uhel;
				pocet++;
			}//if
		}
	}
	else if (metoda==TEST_SOUMERNOST){
		for (int i=0; i<count; i++){
			//pokud splnuje podminku soumernosti, predam na vystup
			if (soumernost(image, icorners[i], okno, tresh)==1){//je to roh sachovnice
				corners[pocet] = icorners[i];
				pocet++;
			}//if

		}
	}
	cvFree(&icorners);
	return pocet;
}


int keypoints2corners(vector <cv::KeyPoint> &keypoints, CvPoint2D32f * corners, int maxcount){
	//preda keypoints do corners a odstrani blizke body
	//predpoklada body v keypoints serazene podle y souradnice
	int pocet = 0;
	int uk_relevant = 0;
	int j;
	unsigned int i;
	bool found;
	const int min_size=10;
	double x, y;

	for (i=0; i<keypoints.size(); i++){
		found = false;
		//posun ukazatele
    y = (keypoints[i].pt.y);
		x = (keypoints[i].pt.x);
		if (pocet>0)
			while ((uk_relevant<pocet)&&(abs(y - corners[uk_relevant].y)>min_size))
				uk_relevant++;
		j=uk_relevant;
		while ((!found)&&(j<pocet)){//kontrola jen relevantnich bodu
			found = (abs(corners[j].x-x)<min_size);
			j++;
		}
		if (!found){//nenalezen, dam na vystup
			corners[pocet] = keypoints[i].pt;
			pocet++;
			if (pocet>=maxcount) break;
		}
	}
	return pocet;
}

int rem_doubles(CvPoint2D32f * corners, int count, double min_distance, double window){
	//odstrani duplicitnui body
	int pocet = 0;
	int uk_relevant = 0;
	int i, j;
	bool found;
	double x, y;

	CvPoint2D32f * icorners = (CvPoint2D32f*)cvAlloc(count*sizeof(CvPoint2D32f));
	memcpy(icorners, corners, count*sizeof(CvPoint2D32f));
	
	corners[0] = icorners[0];
	pocet=1;
	
	for(i=1; i<count; i++){
		found = false;
		//posun ukazatele
    y = (icorners[i].y);
		x = (icorners[i].x);
		if (i==13){
			cout << "" ;
		}
		while ((uk_relevant<pocet)&&(abs(y - corners[uk_relevant].y)>window))//
				uk_relevant++;
		j=uk_relevant;
		while ((!found)&&(j<=pocet)){//kontrola jen relevantnich bodu
			found = ((abs(corners[j].x-x)<min_distance)&&(abs(corners[j].y-y)<min_distance));
			j++;
		}//while
		if (!found){//nenalezen, dam na vystup
			corners[pocet] = icorners[i];
			pocet++;
		}//if
	}//for

	cvFree(&icorners);
	return pocet;
}//rem_doubles

int get_chesscorners(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, int maxcount, int okno, int thresh){
	int count  = maxcount;
	IplImage * grey = NULL;
	if ((image->depth==8)&&(image->nChannels==1))//je to grayscale
		grey = image;
	else {
		grey = cvCreateImage( cvGetSize(image), 8, 1 );
  //status = (char*)cvAlloc(maxcount);
  //flags = 0;
		cvCvtColor( image, grey, CV_BGR2GRAY );
	}
	IplImage* eig = cvCreateImage( cvGetSize(grey), 32, 1 );
  IplImage* temp = cvCreateImage( cvGetSize(grey), 32, 1 );
  double quality = 0.01;
  double min_distance = 10;
	int win_size = 10;

	vector <cv::KeyPoint> keypoints;// = new vector <cv::KeyPoint>;//* keypoints = new vector <cv::KeyPoint>;
	
	FAST(grey, keypoints, thresh, false);

	count = keypoints2corners(keypoints, corners, maxcount);

	//cvGoodFeaturesToTrack( grey, eig, temp, corners, &count, quality, min_distance, 0, 3, 0, 0.04 );//nalezne rohy v obraze
  cvFindCornerSubPix( grey, corners, count, cvSize(win_size, win_size), cvSize(-1,-1), cvTermCriteria(CV_TERMCRIT_ITER|CV_TERMCRIT_EPS,20,0.03));//vylepseni pozice rohu

	count = rem_doubles(corners, count, 0.2, min_distance*2);


	//filtrace pouze sachovnicovych rohu

	int chesscount = test_soumernosti(grey, corners, uhly, count, okno, 70, TEST_PRINCIPAL);

	cvReleaseImage( &eig );
  cvReleaseImage( &temp );
	if (grey!=image)
		cvReleaseImage( &grey );
	keypoints.clear();

	return chesscount;

}


void create_rand_uhly(CvScalar &uhel, CvRNG * rng){
	//vyvoreni nahodneho uhlu
	double principal = cvRandReal(rng)*CV_PI/2.0;//orientace sach bodu
	const double min_uhel = CV_PI/15.;
	const double sum = CV_PI/20.;
	double step = min_uhel + cvRandReal(rng)*(CV_PI/2.0-min_uhel);//sesikmenost
	uhel.val[0] = principal + (cvRandReal(rng)-0.5)*sum;
	uhel.val[1] = principal+step +(cvRandReal(rng)-0.5)*sum;
	uhel.val[2] = principal+CV_PI + (cvRandReal(rng)-0.5)*sum;
	uhel.val[3] = principal+CV_PI+step + (cvRandReal(rng)-0.5)*sum;
	return;
}

int create_test_data(IplImage * image, CvPoint2D32f *corners, CvScalar *uhly, CvSize objekt_size, CvPoint objekt_pos, int maxcount, int okno){
	//detekne rohy sachovnice a doplne je o nahodne generovane outliery
	//CvScalar * uhly = (CvScalar *)cvAlloc(maxcount*sizeof(CvScalar));

	int count = get_chesscorners(image, corners, uhly, maxcount, okno, 60);
	int i;
	int objekt = 8*count;
	CvPoint2D32f bod;
	int pocet = count;
	CvRNG rg = cvRNG(cvGetTickCount());


	for (i=0; i< count; i++){//generovani bodu v prostoru obrazku
		if (pocet>maxcount) break;
		bod.x = (float)cvRandReal(&rg)*(image->width-1);
		bod.y = (float)cvRandReal(&rg)*(image->height-1);
		corners[pocet] = bod;
		create_rand_uhly(uhly[pocet], &rg);
		pocet++;
	}
	for (i=0; i< objekt; i++){//generovani bodu v prostoru objektu
		if (pocet>maxcount) break;
		bod.x = objekt_pos.x + (float)cvRandReal(&rg)*(objekt_size.width-1);
		bod.y = objekt_pos.y + (float)cvRandReal(&rg)*(objekt_size.height-1);
		corners[pocet] = bod;
		create_rand_uhly(uhly[pocet], &rg);
		pocet++;
	}
	
	cvFree(&uhly);
	return pocet;
}

void draw_chesscorners(IplImage * image, CvPoint2D32f * corners, CvScalar * uhly, int count, int size, CvScalar color){
	//vykresleni rohu
	int j, i;
	CvPoint stred, stop;
	double R = (double)size;
	
	cout << " count " << count << endl;
	for (i=0; i<count; i++){
		stred = cvPointFrom32f(corners[i]);
		if(uhly != NULL)
			for (j=0; j<4; j++){//vykresli uhly
				stop.x = cvRound(corners[i].x + cos(uhly[i].val[j])*R);
				stop.y = cvRound(corners[i].y + sin(uhly[i].val[j])*R);
				cvLine(image, stred, stop, color, 2);
			}
		//cvCircle(image, cvPoint(stred.x + rand()%10-5, stred.y), size, color, 1);
		cvCircle(image, stred, size, color, 1);
		//cout << stred.x <<  " \t " << stred.y << endl;
	}//for
	return;
}



int Sobel_value(IplImage * img, int x, int y){
	//vypocte hodnotu gradientu v prislusnem bode
	int dx, dy, d;
	dx = dy = 0;
	if ((x>0)&&(y>0)&&(x<img->width-1)&&(y<img->height-1)){
		dx = getPixel(img, x-1, y-1, 0) - getPixel(img, x+1, y-1, 0);
		dx += 2*getPixel(img, x-1, y, 0) - 2*getPixel(img, x+1, y, 0);
		dx += getPixel(img, x-1, y+1, 0) - getPixel(img, x+1, y+1, 0);

		dy = getPixel(img, x-1, y-1, 0) - getPixel(img, x-1, y+1, 0);
		dy += 2*getPixel(img, x, y-1, 0) - 2*getPixel(img, x, y+1, 0);
		dy += getPixel(img, x+1, y-1, 0) - getPixel(img, x+1, y+1, 0);

		d = abs(dx) + abs(dy);
		return min(d, 255);
	}
	else return 0;
}

void Sobel(IplImage * src, IplImage * dst){
	for (int x = 0; x< src->width; x++)
		for (int y = 0; y< src->height; y++)
			((uchar*)(dst->imageData + dst->widthStep*y))[x] = Sobel_value(src, x, y);
}

bool check_onlines_sobel(IplImage * image, CvPoint2D32f bod1, CvPoint2D32f bod2, int thres){
	//test zda jsou body na hrane(jakekoliv hrane!!!)
	CvPoint2D32f vektor, vysl, sample;
	vektor.x = bod2.x-bod1.x;
	vektor.y = bod2.y-bod1.y;

	float krok;
	int count, sv;
	count=0;

	if ((vektor.x==0.) && (vektor.y==0.))	return true;
	if (abs(vektor.x)<abs(vektor.y)){//jdu po ose y
		krok = vektor.y/abs(vektor.y);
		sample.y = krok;
		while (abs(sample.y)<abs(vektor.y)){
			sample.x = (vektor.x*sample.y)/vektor.y;
			vysl.x = sample.x + bod1.x;
			vysl.y = sample.y + bod1.y;
			sv = Sobel_value(image, cvRound(vysl.x), cvRound(vysl.y)); 
			//cout << sv << " ";
			if (sv>thres)
					count++;
			//cvCircle(image, vysl, 1, CV_RGB(100, 100, 200));
			sample.y += krok;
		}
		return (count>abs(vektor.y)*9/10);
	}
	else{ //postup po ose x
		krok = vektor.x/abs(vektor.x);
		sample.x = krok;
		while (abs(sample.x)<abs(vektor.x)){
			sample.y = (vektor.y*sample.x)/vektor.x;
			vysl.x = sample.x + bod1.x;
			vysl.y = sample.y + bod1.y;
			sv = Sobel_value(image, cvRound(vysl.x), cvRound(vysl.y)); 
			//cout << sv << " ";
			if (sv>thres)
					count++;
			//cvCircle(image, vysl, 1, CV_RGB(100, 100, 200));
			sample.x += krok;
		}
		return (count>abs(vektor.x)*9/10);
	}
	return false;
}


int rozdil_kolem(IplImage * image, CvPoint2D32f bod, CvPoint2D32f normala){
	//rozdil bodu podel vektoru
	CvPoint left, right;
	left.x = cvRound(bod.x+normala.x);
	left.y = cvRound(bod.y+normala.y);
	right.x = cvRound(bod.x-normala.x);
	right.y = cvRound(bod.y-normala.y);
	
	if ((inImage(image, left.x, left.y))&&(inImage(image, left.x, left.y)))
		return (getPixel(image, left.x, left.y, 0)-getPixel(image, right.x, right.y, 0));
	else return 0;

}

bool check_onlines(IplImage * image, CvPoint2D32f bod1, CvPoint2D32f bod2, int thres, int edgethres){
	//test, zda jsou body spojeny hranou, "stejnou" po cele delce
	const int SAMPMAX = 128;
	CvPoint2D32f samply[SAMPMAX];
	memset(samply, 0, sizeof(samply));

	CvPoint2D32f vektor, normala, interval;
	vektor.x = bod2.x-bod1.x;
	vektor.y = bod2.y-bod1.y;

	float size = sqrtf(vektor.x*vektor.x + vektor.y*vektor.y);
	int samplu, positives, negatives, uroven, maxsamplu, rozdil, tested, hodnota;
	
	if (size>2.0){
		
		normala.x = 2.5f*vektor.y/size;
		normala.y = 2.5f*(-vektor.x/size);

		samply[0].x = (bod2.x + bod1.x)/2.0f;
		samply[0].y = (bod2.y + bod1.y)/2.0f;

		maxsamplu = cvCeil(size);
		samplu = 1;
		uroven = 2;
		positives = negatives = tested = 0;
		while ((samplu<=maxsamplu/2)&&(samplu<=SAMPMAX/2)){
			interval.x = vektor.x/(2*uroven);
			interval.y = vektor.y/(2*uroven);
			for (int i=0; i< samplu; i++){//vyhodnoceni a rozgenerovani
				rozdil = rozdil_kolem(image, samply[i], normala);
				if (rozdil>edgethres) positives++;
				else if (rozdil<-edgethres) negatives++;
				tested++;
				samply[i+samplu].x = samply[i].x+interval.x;
				samply[i+samplu].y = samply[i].y+interval.y;
				samply[i].x = samply[i].x-interval.x;
				samply[i].y = samply[i].y-interval.y;
			}//for
			samplu*=2;
			if (uroven>3){
				hodnota = max(100*positives/tested, 100*negatives/tested);
				if (hodnota>thres) return true;
				else if (hodnota<(100-thres)) return false;
			}//if
			uroven++;
		}//while
		if (tested>0){
			if ((100*positives/tested>thres)||(100*negatives/tested>thres)) return true;
			else return false;
		}
		else {
			return false;
		}
	}//bigif
	else return true;
}