#include "camera_kalman.h"
#include <iostream>


using namespace std;

CameraKalman::CameraKalman(){
	//konstruktor
	//meri se 6 parametru, ve stavech jeste sest pro rychlosti
	const float A[] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 ,0 ,0, 
											0, 1, 0, 0, 0, 0, 0, 0, 0, 0 ,0 ,0,
											0, 0, 1, 1, 0, 0, 0, 0, 0, 0 ,0 ,0,
											0, 0, 0, 1, 0, 0, 0, 0, 0, 0 ,0 ,0,
											0, 0, 0, 0, 1, 1, 0, 0, 0, 0 ,0 ,0,
											0, 0, 0, 0, 0, 1, 0, 0, 0, 0 ,0 ,0,
											0, 0, 0, 0, 0, 0, 1, 1, 0, 0 ,0 ,0,
											0, 0, 0, 0, 0, 0, 0, 1, 0, 0 ,0 ,0,
											0, 0, 0, 0, 0, 0, 0, 0, 1, 1 ,0 ,0,
											0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ,0 ,0,
											0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,1 ,1,
											0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0 ,1 };
	const float H[] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0 ,0,
											0, 0, 1, 0, 0, 0, 0, 0, 0, 0 ,0 ,0,
											0, 0, 0, 0, 1, 0, 0, 0, 0, 0 ,0 ,0, 
											0, 0, 0, 0, 0, 0, 1, 0, 0, 0 ,0 ,0, 
											0, 0, 0, 0, 0, 0, 0, 0, 1, 0 ,0 ,0, 
											0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,1 ,0, };
	kalman = NULL;
	kalman  = cvCreateKalman( 12, 6, 0 );			/* x, dx, y, dy, z, dz, rx, drx, ry, dry, rz, drz */

	//cvRandInit( &rng, 0, 1, -1, CV_RAND_UNI );

	memcpy( kalman->transition_matrix->data.fl,  A, sizeof(A));
	memcpy( kalman->measurement_matrix->data.fl, H, sizeof(H));

  //cvSetIdentity( kalman->measurement_matrix, cvRealScalar(1) );
  cvSetIdentity( kalman->process_noise_cov, cvRealScalar(1e-4) );
  cvSetIdentity( kalman->measurement_noise_cov, cvRealScalar(1e-9) );
  cvSetIdentity( kalman->error_cov_post, cvRealScalar(1));

	cvZero( kalman->state_post );

	inited = false;
}

CameraKalman::~CameraKalman(){
	//destruktor
	cvReleaseKalman(&kalman);
}

int CameraKalman::init(CvMat * position, CvMat * rotation){
	//inicializace prvotniho stavu filtru
	if ((position!=NULL)&&(rotation!=NULL)&&(max(position->cols, position->rows)==3)&&(max(rotation->cols, rotation->rows)==3)) {
		cvZero( kalman->state_post);
		for (int i=0; i<3; i++){
			/* x, dx, y, dy, z, dz, rx, drx, ry, dry, rz, drz */
			kalman->state_post->data.fl[i*2] = position->data.fl[i];
			kalman->state_post->data.fl[6+i*2] = rotation->data.fl[i];
		}//for
		inited = true;
	}//if
	return inited;
}


int CameraKalman::predict(CvMat * position, CvMat * rotation){
	//predikce kalmana na zaklade minulych dat
	if ((position!=NULL)&&(rotation!=NULL)&&(max(position->cols, position->rows)==3)&&(max(rotation->cols, rotation->rows)==3)&&(inited)){
		cvKalmanPredict( kalman, 0 );
		for (int i=0; i<3; i++){
			/* x, dx, y, dy, z, dz, rx, drx, ry, dry, rz, drz */
			position->data.fl[i] = kalman->state_pre->data.fl[i*2];
			rotation->data.fl[i] = kalman->state_pre->data.fl[6+i*2];
		}//for
		return 1;
	}//if
	else return 0;
}


int CameraKalman::update(CvMat * position, CvMat * rotation){
	//CvMat m = cvMat( 3, 1, CV_32FC1, (void *)(&best) );
	//		if( d < 0 )
	//		{
	//			// generate measurement
	//			CvRNG rng = cvRNG(-1);
	//			cvRandArr( &rng, &m, CV_RAND_NORMAL, cvRealScalar(0), cvRealScalar(sqrt(ud->face->kalman->measurement_noise_cov->data.fl[0])) );
	//			cvMatMulAdd( ud->face->kalman->measurement_matrix, ud->face->kalman->state_post, &m, &m );
	//		}
	//
	if ((position!=NULL)&&(rotation!=NULL)&&(max(position->cols, position->rows)==3)&&(max(rotation->cols, rotation->rows)==3)&&(inited)){
		CvMat * measurement = cvCreateMat(6, 1, CV_32FC1);

		for (int i=0; i<3; i++){
			/* x, dx, y, dy, z, dz, rx, drx, ry, dry, rz, drz */
			measurement->data.fl[i] = position->data.fl[i];
			measurement->data.fl[3+i] = rotation->data.fl[i];
		}//for

		//roznasobit noisem measurement???

		cvKalmanCorrect( kalman, measurement );

		//roznasobit noisem???
		
		//CvMat* state = cvCreateMat( 2, 1, CV_32FC1 );
		//CvMat* process_noise = cvCreateMat( 6, 1, CV_32FC1 );

		//cvRandSetRange( &rng, 0, sqrt(kalman->process_noise_cov->data.fl[0]),0 );
		//cvRand( &rng, process_noise );
		//cvMatMulAdd( kalman->transition_matrix, state, process_noise, state );
		return 1;
	}//if
	else return 0;
	//		state2point( ud->face->kalman->state_post, ud->face->last );
	return 1;
}


/////////////////////////////////////////////////////////////////////////////////////////////////

OptFlowTracker::OptFlowTracker(){
	//konstruktor
	inited = false;
	prev_grey = pyramid = prev_pyramid = NULL;
	flags = 0;
}

OptFlowTracker::~OptFlowTracker(){
	//destruktor
	if (inited){
		cvReleaseImage(&prev_grey);
		cvReleaseImage(&pyramid);
		cvReleaseImage(&prev_pyramid);
	}//if
}

int OptFlowTracker::track(IplImage* grey, CvPoint2D32f * corners, char * status, int count, bool subpix_precise){
	if (!inited){//prvni volani, inicializace trackeru
		if (grey!=NULL){
			prev_grey = cvCreateImage( cvGetSize(grey), 8, 1 );
			pyramid = cvCreateImage( cvGetSize(grey), 8, 1 );
			prev_pyramid = cvCreateImage( cvGetSize(grey), 8, 1 );
			cvCopy(grey, prev_grey);
			inited = true;
		}
	}
	else{
		CvPoint2D32f * icorners = (CvPoint2D32f*)cvAlloc(count*sizeof(CvPoint2D32f));
		memcpy(icorners, corners, count*sizeof(CvPoint2D32f));

		cvCalcOpticalFlowPyrLK( prev_grey, grey, prev_pyramid, pyramid,
                icorners, corners, count, cvSize(10,10), 3, status, 0,
                cvTermCriteria(CV_TERMCRIT_ITER|CV_TERMCRIT_EPS,20,0.03), flags );
    flags |= CV_LKFLOW_PYR_A_READY;
		cvFree(&icorners);
		cvCopy(grey, prev_grey);
		cvCopy(pyramid, prev_pyramid);
		if (subpix_precise)
			cvFindCornerSubPix(grey, corners, count, cvSize(10, 10), cvSize(-1,-1), cvTermCriteria(CV_TERMCRIT_ITER|CV_TERMCRIT_EPS,5,0.5));//vylepseni pozice rohu
	}
	return 0;
}//track