#pragma once

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>
#include <iostream>
#include <fstream>

#include "FlowTracker.h"

using namespace cv;
using namespace std;

class PointObserver
{
public:
	int max_points;
	int counter;
	bool init;

	Ptr<FeatureDetector> detector;		//detector
	Ptr<DescriptorExtractor> extractor;	//extractor
	Ptr<DescriptorMatcher> matcher;		//matcher

	FlowTracker tracker;

	//image1 points
	vector<KeyPoint> keys;
	vector<Point3f> keys3D;
	vector<char> state3D;
	vector<unsigned long> keyID;
	unsigned long IDcount;
	Mat descs;

	//image2 points
	vector<KeyPoint> keys2;
	Mat descs2;

	//matches
	vector<DMatch> matches;

	//observer movement tracking
	Mat cam_D;	//distortion coeffs
	Mat cam_A;	//camera matrix
	Mat cam_R;	//camera rotation
	Mat cam_R2;	//camera rotation
	Mat cam_T;	//camera translation
	Mat cam_T2;	//camera translation

	Mat dep_D;	//distortion coeffs
	Mat dep_A;	//camera matrix

	Mat F;		//fundamental matrix
	Mat E;		//essential matrix

	vector<Point2f> p2D;
	vector<Point3f> p3D;

	vector<Point3f> poss;
	vector<Point3f> rots;

	vector<uchar> states;

	//tracking
	int getDepth(int x, int y, const Mat& depth, Point3f &p);
	void trackPoints(const Mat& grey, const Mat& depth, int keyframe);
	void findKeyPoints(const Mat& grey);
	void matchKeyPoints(const Mat& grey);
	void switchKeyPoints();
	//camera
	void loadMatrix(char *name, Mat& mat);
	void computeF();

	//filewrite
	ofstream write;
	int frame;

	PointObserver(int count);
	~PointObserver(void);
};

