#include "FlowTracker.h"


FlowTracker::FlowTracker(void)
{
	//konstruktor
	inited = false;
	flags = 0;
}


FlowTracker::~FlowTracker(void)
{
	//destruktor
	if (inited){
		prev_grey.~Mat();
		state.~vector();
		err.~vector();
	}//if
}

int FlowTracker::track(const Mat& grey, vector<KeyPoint>& corners, bool subpix_precise){
	if (!inited)
	{//prvni volani, inicializace trackeru
		if (grey.data)
		{
			grey.copyTo(prev_grey);
			inited = true;	
		}

		state.resize(corners.size());
		for(int a = 0; a < state.size(); a++)
			state.at(a) = 1;
	}
	else {
		vector<Point2f> icorners(corners.size());
		vector<Point2f> corners2(corners.size());
		//copy corners to icorners
		KeyPoint::convert(corners, icorners, std::vector<int>());
		state.resize(corners.size());

		calcOpticalFlowPyrLK( prev_grey, grey, icorners, corners2, state, err, 
			cvSize(10,10), 3, cvTermCriteria(CV_TERMCRIT_ITER|CV_TERMCRIT_EPS,10,0.03), 0.5, 0);
        //flags |= CV_LKFLOW_PYR_A_READY;

		//sweep
		icorners.~vector();
		
		//copy last image
		grey.copyTo(prev_grey);

		if (subpix_precise)
			cornerSubPix(grey, corners2, cvSize(10, 10), cvSize(-1, -1), cvTermCriteria(CV_TERMCRIT_ITER|CV_TERMCRIT_EPS,20,0.03));
		
		//copy back
		KeyPoint::convert(corners2, corners, 1, 1, 0, -1);
	}
	return 0;
}//track