﻿
using System;
using System.Collections;
using System.Text;
namespace ObjectModel.InformationElements
{
    public class InformationSubElement : IObjectbase
    {
        protected InformationElementBase parent;
        protected DataCollection data;
        protected int dataBase, dataOffset;
        protected long m_value;

        public InformationElementBase Parent
        {
            get { return parent; }
            set { parent = value; }
        }
        public int DataOffset
        {
            get { return dataOffset; }
            set { dataOffset = value; }
        }
        public int DataBase
        {
            get { return dataBase; }
            set { dataBase = value; }
        }
        public byte[] Data
        {
            get
            {
                int len = this.Length / 8;
                if (this.Length % 8 > 0)
                    len++;

                byte[] retVal = new byte[len];
                Array.Copy(this.data.Data, this.dataBase, retVal, 0, len);
                return retVal;
            }
        }
        public virtual int Length
        {
            get { return 0; }
        }
        public long Value
        {
            get { return m_value; }
            set { m_value = value; }
        }

        public override string ToString()
        {
            return "";
        }

        protected void setDataValue()
        {
            int aktualnaDlzka = this.Length / 8;
            if (this.Length % 8 > 0)
                aktualnaDlzka++;
            if (this.dataOffset > 0)
                aktualnaDlzka++;

            byte[] dest = new byte[aktualnaDlzka];
            Array.Copy(this.data.Data, this.dataBase, dest, 0, aktualnaDlzka);

            BitArray bity = new BitArray(dest);
            this.m_value = 0;
            setDataByte(bity, aktualnaDlzka);
            string sss = bityString(bity);

            for (int i = this.dataOffset; i < this.dataOffset + this.Length; i++)
            {
                this.m_value *= 2;
                this.m_value += bity[i] ? 1 : 0;
            }
        }

        private void setDataByte(BitArray bity, int aktualnaDlzka)
        {
            for (int i = 0; i < aktualnaDlzka; i++)
            {
                int itmp = i * 8;
                for (int j = 0; j < 4; j++)
                {
                    bool tmp = bity[itmp + j];
                    bity[itmp + j] = bity[itmp + (7 - j)];
                    bity[itmp + (7 - j)] = tmp;
                }
            }
        }

        private string bityString(BitArray bitz)
        {
            StringBuilder sb = new StringBuilder();
            foreach (bool item in bitz)
            {
                sb.Append(item ? "1" : "0");
            }
            return sb.ToString();
        }
    }
}
