﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ObjectModel.InformationElements.Renderers;
using ObjectModel.Renderers;

namespace ObjectModel.InformationElements
{
    public class InformationElementBase : IObjectbase
    {
        protected IInformationElementRenderer renderer;
        protected InformationElementBase parent = null;
        protected Dictionary<string, Object> items = new Dictionary<string, object>();
        protected DataCollection data;
        protected Int32 dataBase, dataOffset;
        protected string name;

        #region Public Interface
        public IInformationElementRenderer Renderer
        {
            get { return renderer; }
            set { renderer = value; }
        }
        public InformationElementBase Parent
        {
            get { return parent; }
            set { parent = value; }
        }
        public Dictionary<string, Object> Items
        {
            get { return items; }
            set { items = value; }
        }
        public byte[] Data
        {
            get
            {
                int len = this.Length / 8;
                byte[] retVal = new byte[len];
                Array.Copy(this.data.Data, this.dataBase, retVal, 0, len);
                return retVal;
            }
        }
        public DataCollection DataColl
        {
            get { return data; }
            set { data = value; }
        }      
        public string Name
        {
            get { return name; }
            set { name = value; }
        }
        public int Length
        {
            get
            {
                int sumLen = 0;
                foreach (var item in this.items.Values)
                {
                    if (item is IObjectbase)
                        sumLen += (item as IObjectbase).Length;
                }
                return sumLen;
            }
        }
        #endregion

        public InformationElementBase()
        { }
        public InformationElementBase(DataCollection data_, Int32 dataBase_, Int32 dataOffset_)
        {
            this.data = data_;
            this.dataBase = dataBase_;
            this.dataOffset = dataOffset_;
        }
        public InformationElementBase(InformationElementBase parent_, Int32 dataBase_, Int32 dataOffset_)
            : this(parent_.data, dataBase_, dataOffset_)
        {
            this.parent = parent_;
        }

        public void RenderData(Object args)
        {
            if (this.renderer != null)
                this.renderer.RenderData(this, args);
        }
        public void RenderInformationElements(Object args)
        {
            if (this.renderer != null)
                this.renderer.RenderInformationElements(this, args);
        }
        public void SetRendererRecursive(IInformationElementRenderer renderer_)
        {
            this.renderer = renderer_;

            foreach (Object obj in this.items.Values)
            {
                if (obj is InformationElementBase)
                    (obj as InformationElementBase).Renderer = renderer_;
            }
        }

        protected void addLength(ref int dataBase_, ref int dataOffset_, ref int len, Object subObject)
        {
            //funkcia prida k dataBase a dataOffset velkost objektu subObject
            int lenSubObjektu = (subObject as IObjectbase).Length;
            int oldPointer = dataBase_ * 8 + dataOffset_;
            int newPointer = oldPointer + lenSubObjektu;

            len = len + lenSubObjektu;
            dataOffset_ = newPointer % 8;
            dataBase_ = newPointer / 8;
        }
        protected bool compareData(byte[] currentData, byte[] userData)
        {
            if (userData.Length > currentData.Length)
                return false;

            for (int i = 0; i < userData.Length; i++)
            {
                if (currentData[i] != userData[i])
                    return false;
            }

            return true;

        }

        public override string ToString()
        {
            if (this.items.Count > 0)
                return this.items.Keys.Last<String>().ToString();

            return "";
        }

    }
}
