﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Xml;
using System.IO;

namespace AnalyzeThisForms.Components
{
	[Serializable]
	public class ProgramSettings
	{

        public static string PluginsSubDir = "Plugins";
		string pluginDirectory;
		string pravidlaDirectory;
		string modelsDirectory;

		public string PluginDirectory
		{
			get { return pluginDirectory; }
			set { pluginDirectory = value; }
		}
		public string PravidlaDirectory
		{
			get { return pravidlaDirectory; }
			set { pravidlaDirectory = value; }
		}
		public string ModelsDirectory
		{
			get { return modelsDirectory; }
			set { modelsDirectory = value; }
		}

		public void Save(string dir)
		{						
			string fullPath = Path.Combine(dir, "Program.Settings");
			TextWriter writer = new StreamWriter(fullPath);
            XmlSerializer serializer = new XmlSerializer(this.GetType());
            serializer.Serialize(writer, this);
            writer.Flush();
            writer.Close();						
		}
		public static ProgramSettings Load(string dir)
		{
			string fullPath = Path.Combine(dir, "Program.Settings");
			ProgramSettings set;

			if (File.Exists(fullPath))
			{
				TextReader reader = new StreamReader(fullPath);
				XmlSerializer serializer = new XmlSerializer(typeof(ProgramSettings));
				set = (ProgramSettings)serializer.Deserialize(reader);
				reader.Close();
			}
			else
			{
				set = new ProgramSettings();
				set.pravidlaDirectory = System.Windows.Forms.Application.CommonAppDataPath;
				set.pluginDirectory = Path.Combine(System.Windows.Forms.Application.StartupPath, ProgramSettings.PluginsSubDir );
				set.modelsDirectory = Path.Combine(System.Windows.Forms.Application.CommonAppDataPath, "Models");

				if (!(Directory.Exists(set.pluginDirectory)))
					Directory.CreateDirectory(set.pluginDirectory);
				if (!(Directory.Exists(set.modelsDirectory)))
					Directory.CreateDirectory(set.modelsDirectory);
			}
			return set;
		}

	}
}
