﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.CodeDom;

namespace MetaModel.Model.InformationSubElementNs
{
    public class Variable : ObjectBase
    {
        System.Type m_type;
        String m_name;

        public Variable()
        { }
        public Variable(string name)
        {
            this.m_name = name;
        }
        public Variable(XmlNode node)
            : base(node)
        { }

        #region Public interface
        public System.Type Type
        {
            get { return m_type; }
            set { m_type = value; }
        }
        public String Name
        {
            get { return m_name; }
            set { m_name = value; }
        }
        #endregion

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;

            //vytvorim novu xmlNode
            this.currentNode = parentDoc.CreateElement(Variable.NodeName);

            //typ premennej
            this.currentNode.InnerText = this.m_type.FullName;
            //meno premennej
            XmlAttribute valAttr = parentDoc.CreateAttribute("Name");
            valAttr.Value = this.m_name;
            this.currentNode.Attributes.Append(valAttr);
            //vlozim sa ako dieta rodica
            parentNode.AppendChild(this.currentNode);
        }

        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //meno premennej
            XmlAttribute nameAttr = node.Attributes["Name"];
            if (nameAttr != null)            
                this.m_name = nameAttr.Value;            
            //typ premennej
            this.m_type = System.Type.GetType(node.InnerText);
        }

        public static new string NodeName = "Variable";

        internal void Compile(System.CodeDom.CodeTypeDeclaration subElementClass)
        {
            //vytvor  premennu value, valuestring            
            CodeMemberField valueField = new CodeMemberField(this.m_type, "m_" + this.m_name);
            subElementClass.Members.Add(valueField);            

            //vytvor public interface pre premenne
            CodeMemberProperty valueProperty = new CodeMemberProperty();
            valueProperty.Name = this.m_name;
            valueProperty.Type = new CodeTypeReference(typeof(long));
            valueProperty.Attributes = MemberAttributes.Public;
            //Add the property to the class
            subElementClass.Members.Add(valueProperty);
            //Add the code snippets into the property
            CodeSnippetExpression getsnippet = new CodeSnippetExpression("return this.m_" + this.m_name);
            valueProperty.GetStatements.Add(getsnippet);
        }
    }
}
