﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.CodeDom;

namespace MetaModel.Model.InformationSubElementNs
{
    public class Meaning : ObjectBase
    {
        Int64? m_value;
        String m_text;

        public Meaning()
        { }
        public Meaning(Int64? value, String text)
        {
            this.m_value = value;
            this.m_text = text;
        }
        public Meaning(XmlNode node)
            : base(node)
        { }

        #region Public Interface
        public Int64? Value
        {
            get { return m_value; }
            set { m_value = value; }
        }
        public String Text
        {
            get { return m_text; }
            set { m_text = value; }
        }
        #endregion

        public override void LoadFromXml(XmlNode node)
        {
            XmlAttribute valAttr = node.Attributes["Value"];
            if (valAttr != null)
                if (valAttr.Value.StartsWith("0x"))
                {
                    this.m_value = Int64.Parse(valAttr.Value.Substring(2), System.Globalization.NumberStyles.HexNumber);
                }
                else
                {
                    this.m_value = Int64.Parse(valAttr.Value);
                }
            this.m_text = node.InnerText;
        }
        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            //vytvorim novu xmlNode
            this.currentNode = parentDoc.CreateElement(Meaning.NodeName);

            //text
            this.currentNode.InnerText = this.m_text;
            //value
            if (this.m_value != null)
            {
                XmlAttribute valAttr = parentDoc.CreateAttribute("Value");
                valAttr.Value = "0x" + this.m_value.Value.ToString("X8");
                this.currentNode.Attributes.Append(valAttr);
            }
            //vlozim sa ako dieta rodica
            parentNode.AppendChild(this.currentNode);
        }

        public static new string NodeName = "Meaning";

        /// <summary>
        /// funkcia vytvori riadok v parsovacej funkci
        /// </summary>
        /// <param name="subElementClass"></param>
        /// <param name="parseFunction"></param>
        internal void Compile(System.CodeDom.CodeTypeDeclaration subElementClass, System.CodeDom.CodeMemberMethod parseFunction)
        {
            if (this.m_value != null)
            {
                CodeConditionStatement podmienkaMeaningu = new CodeConditionStatement();
                //podmienka
                CodeSnippetExpression podmienka = new CodeSnippetExpression();
                podmienka.Value = "this.m_value == " + this.m_value;
                podmienkaMeaningu.Condition = podmienka;
                //prikazy ktora sa vykonaju po splneni podmienky            
                podmienkaMeaningu.TrueStatements.Add(
                    new CodeSnippetStatement("\t\t\t\tthis.m_valueString = \"" + this.m_text + "\";"));
                podmienkaMeaningu.TrueStatements.Add(
                    new CodeSnippetStatement("\t\t\t\treturn;"));
                parseFunction.Statements.Add(podmienkaMeaningu);
            }
            else
            {
                parseFunction.Statements.Add(
                     new CodeSnippetStatement("\t\t\tthis.m_valueString = \"" + this.m_text + "\";"));
            }
        }

        public static int OrderByValue(Meaning a, Meaning b)
        {
            if (a.m_value == null || b.m_value == null)
            {
                if (a.m_value == null && b.m_value == null)
                    return 0;
                else if (a.m_value == null)
                    return 1;
                else if (b.m_value == null)
                    return -1;
            }
            //oba maju hodnotu
            return (int)(a.m_value.Value - b.m_value.Value);
        }
    }
}
