﻿using System;
using System.CodeDom;
using System.Collections.Generic;
using System.Xml;

namespace MetaModel.Model.InformationSubElementNs
{
    public class CustomParser: ObjectBase
    {
        String m_parseFunction;
        List<Variable> m_variables = new List<Variable>();

        public CustomParser()
        { }
        public CustomParser(XmlNode node)
            : base(node)
        { }

        #region Public interface
        public String ParseFunction
        {
            get { return m_parseFunction; }
            set { m_parseFunction = value; }
        }
        public List<Variable> Variables
        {
            get { return m_variables; }
            set { m_variables = value; }
        } 
        #endregion

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(CustomParser.NodeName);
            
            //ulozim kod            
            XmlNode functionNode = parentDoc.CreateElement("Code");
            functionNode.InnerText = this.m_parseFunction;
            this.currentNode.AppendChild(functionNode);
            
            foreach (var item in this.m_variables)                            
                item.SaveToXml(this.currentNode);
           
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);
        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //nacitam kod            
            XmlNode codeNode = node.SelectSingleNode("Code");
            this.m_parseFunction = codeNode.InnerText;

            //nacitam premenne            
            XmlNodeList variables = node.SelectNodes("Variable");
            foreach (XmlNode item in variables)
                this.m_variables.Add(new Variable(item));            
        }
        
        public static new string NodeName = "CustomParser";

        internal void Compile(CodeTypeDeclaration subElementClass, CodeMemberMethod parseFunction)
        {
            CodeSnippetStatement val = new CodeSnippetStatement(this.ParseFunction);
            parseFunction.Statements.Add(val);
            
            foreach (var item in this.m_variables)
            {
                item.Compile(subElementClass);
            }
        }
    }
}
