﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MetaModel.Model.DataSets;
using System.Xml;
using System.CodeDom;
using MetaModel.Compiler;

namespace MetaModel.Model.InformationElementNs
{  
    public class InformationElement : ObjectBase, IDataChild
    {

        Children m_children;
        CustomToString m_customToString;
        CustomParse m_parseFunction;
        Int32? m_length;        
        Data m_parent = null;

        public InformationElement()
        { }
        public InformationElement(Data parent_)
        {
            this.m_parent = parent_;
        }
        public InformationElement(XmlNode node)
            : base(node)
        { }
        public InformationElement(XmlNode node, Data parent_)
            : base(node)
        {
            this.m_parent = parent_;
        }
        public InformationElement(string name_)
        {
            this.id = Guid.NewGuid();
            this.m_children = new Children();
            this.name = name_;
        }

        public Data Parent
        {
            get { return m_parent; }
            set { m_parent = value; }
        }
        public Children Children
        {
            get { return m_children; }
            set { m_children = value; }
        }
        public CustomParse ParseFunction
        {
            get { return m_parseFunction; }
            set { m_parseFunction = value; }
        }
        public CustomToString CustomToString
        {
            get { return m_customToString; }
            set { m_customToString = value; }
        }
        public Int32? Length
        {
            get { return m_length; }
            set { m_length = value; }
        }        

        public static new string NodeName = "InformationElement";
        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(InformationElement.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //Id .. povinne
            this.SaveId(parentDoc);
            //Name .. povinne
            this.SaveName(parentDoc);

            //Length .. nepovinne
            if (this.m_length != null)
            {
                XmlAttribute lenAttr = parentDoc.CreateAttribute("Length");
                lenAttr.Value = this.m_length.ToString();
                this.currentNode.Attributes.Append(lenAttr);
            }
            
            //ulozim children
            if (this.m_children != null)
                this.m_children.SaveToXml(this.currentNode);
            //custom parser
            if (this.m_parseFunction != null)
                this.m_parseFunction.SaveToXml(this.currentNode);
            //custom toString
            if (this.m_customToString != null)
                this.m_customToString.SaveToXml(this.currentNode);
        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //Length .. nepovinne
            XmlAttribute lenAttr = node.Attributes["Length"];
            if (lenAttr != null)
                this.m_length = Int32.Parse(lenAttr.Value);
            //Id .. povinne
            XmlAttribute idAttr = node.Attributes["Id"];
            if (idAttr != null)
            {
                this.Id = new Guid(idAttr.Value);
                ObjectReferenceLoadCache.RegisterReferencedObject += this.registerReferencedObject;
            }            
            //Name .. povinne
            XmlAttribute nameAttr = node.Attributes["Name"];
            if (nameAttr != null)
                this.name = nameAttr.Value;

            //nacitam premenne          
            //meanings
            //custom parser
            XmlNode children = node[Children.NodeName];
            if (children != null)
                this.m_children = new Children(children);
            //custom parser
            XmlNode customParseNd = node[CustomParse.NodeName];
            if (customParseNd != null)
                this.m_parseFunction = new CustomParse(customParseNd);
            //custom toString
            XmlNode customToString = node[CustomToString.NodeName];
            if (customToString != null)
                this.m_customToString = new CustomToString(customToString);
        }
        private void registerReferencedObject(ObjectReferenceLoadCache cache)
        {
			if (cache.ReferencedObjects.ContainsKey(this.id))
			{
				this.Parent.Elements.Remove(this);
				return;
			}
            cache.ReferencedObjects.Add(this.id, this);
        }

        internal void Compile(System.CodeDom.CodeTypeDeclaration elementClass)
        {
            elementClass.Name = this.name.Replace(" ", "_");
            elementClass.BaseTypes.Add("InformationElementBase");

            //default konstruktor                                   
            CodeConstructor constructor1 = new CodeConstructor();
            constructor1.Name = this.name;
            //Assign a name for the method.            
            constructor1.Attributes = MemberAttributes.Public;
            elementClass.Members.Add(constructor1);

            //default konstruktors s parametrami                                                                             
            CodeConstructor constructorWithParam = new CodeConstructor();
            constructorWithParam.Name = this.name;
            constructorWithParam.Parameters.Add(new CodeParameterDeclarationExpression("InformationElementBase", "parent_"));
            constructorWithParam.Parameters.Add(new CodeParameterDeclarationExpression("System.Int32", "dataBase_"));
            constructorWithParam.Parameters.Add(new CodeParameterDeclarationExpression("System.Int32", "dataOffset_"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.parent = parent_;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.data = parent_.DataColl;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.dataBase = dataBase_;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.dataOffset = dataOffset_;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.ParseData();"));
            //Assign a name for the method.            
            constructorWithParam.Attributes = MemberAttributes.Public;
            elementClass.Members.Add(constructorWithParam);

            //vytvor funkciu parsedata            
            CodeMemberMethod parseDataMethod = new CodeMemberMethod();
            //Assign a name for the method.
            parseDataMethod.Name = "ParseData";
            CodeTypeMemberCollection localVariables = new CodeTypeMemberCollection();

            if (this.m_parseFunction == null)
            {
                //treba pripravit hodnotu pre parser                                
                parseDataMethod.Statements.Add(
                    new CodeSnippetStatement("\t\t\tint tmpBase = this.dataBase;"));
                parseDataMethod.Statements.Add(
                    new CodeSnippetStatement("\t\t\tint tmpOffset = this.dataOffset;"));
                parseDataMethod.Statements.Add(
                    new CodeSnippetStatement("\t\t\tint tmpLength = 0;"));

                //vytvor info potrebne na ulozenie referencovanych itemov
                CompileInfo info = new CompileInfo();
                //nacitaj referencovane objekty
                this.m_children.GetReferencedObjects(info);

                this.m_children.Compile(parseDataMethod.Statements, info, localVariables);                
            }
            else
            {
                //ma vlastny parser
                //nakopiruj obsah do funckie parsedata a vztvor si lokalne premenne
                this.m_parseFunction.Compile(parseDataMethod.Statements, localVariables);                
            }

            //nastav region a pridaj lokalne premenne
            if (localVariables.Count > 0)
            {
                localVariables[0].StartDirectives.Add(new CodeRegionDirective(CodeRegionMode.Start, "Local Variables"));
                localVariables[localVariables.Count - 1].EndDirectives
                    .Add(new CodeRegionDirective(CodeRegionMode.End, "Local Variables"));

                elementClass.Members.AddRange(localVariables);
            }
            elementClass.Members.Add(parseDataMethod);            

        }
    }
}
