﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MetaModel.Model.DataSets;
using System.Xml;
using System.CodeDom;
using MetaModel.Compiler;

namespace MetaModel.Model.InformationElementNs
{
    public class CustomParse : ObjectBase
    {
        String m_code;
        List<Item> m_items = new List<Item>();

        public CustomParse()
        { }
        public CustomParse(XmlNode node)
            : base(node)
        { }

        public String Code
        {
            get { return m_code; }
            set { m_code = value; }
        }
        public List<Item> Items
        {
            get { return m_items; }
            set { m_items = value; }
        }

        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(CustomParse.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //ulozim kod            
            XmlNode functionNode = parentDoc.CreateElement("Code");
            functionNode.InnerText = this.m_code;
            this.currentNode.AppendChild(functionNode);
            //a premenne
            foreach (var item in this.m_items)
                item.SaveToXml(this.currentNode);            
        }
        public override void LoadFromXml(XmlNode node)
        {
            //nacitam kod            
            XmlNode codeNode = node.SelectSingleNode("Code");
            this.m_code = codeNode.InnerText;

            //nacitam premenne            
            XmlNodeList variables = node.SelectNodes(Item.NodeName);
            foreach (XmlNode item in variables)
                this.m_items.Add(new Item(item));       
        }
        public static new string NodeName = "CustomParse";

        public void Compile(
            CodeStatementCollection parseFunction,            
            CodeTypeMemberCollection localVariablesCollection)
        {
            CodeSnippetStatement val = new CodeSnippetStatement(this.m_code);
            parseFunction.Add(val);

            foreach (var item in this.m_items)
            {
                item.CompileCreateLocalVariable(localVariablesCollection);
            }
        }
    }
}
