﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace MetaModel.Model
{
    public class Header : ObjectBase
    {
        List<string> m_includes = new List<string>();

        public Header()
        { }
        public Header(XmlNode node)
            : base(node)
        { }

        public List<string> Includes
        {
            get { return m_includes; }
            set { m_includes = value; }
        }

        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement("Header");
            parentNode.AppendChild(this.currentNode);

            foreach (var item in this.m_includes)
            {
                XmlNode includeNode = parentDoc.CreateElement("Include");
                includeNode.InnerText = item;
                this.currentNode.AppendChild(includeNode);
            }
                        
           
        }

        public override void LoadFromXml(XmlNode node)
        {            
            XmlNodeList subElements = node.SelectNodes("Include");
            foreach (XmlNode item in subElements)
                this.m_includes.Add(item.InnerText);
        }
    }
}
