﻿using System.Collections.Generic;
using System.Xml;
using System.CodeDom;

namespace MetaModel.Model.DataSets
{
    public class Sequence : ObjectBase, IChild
    {
        List<SequenceChild> m_children = new List<SequenceChild>();

        public Sequence()
        { }
        public Sequence(XmlNode node)
            : base(node)
        { }

        public List<SequenceChild> Children
        {
            get { return m_children; }
            set { m_children = value; }
        }

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Sequence.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //ulozim Children
            foreach (var item in this.m_children)
                item.SaveToXml(this.currentNode);
        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //children
            XmlNodeList subElements = node.SelectNodes(SequenceChild.NodeName);
            foreach (XmlNode item in subElements)
                this.m_children.Add(new SequenceChild(item));      
        }
        public static new string NodeName = "Sequence";

        public void GetReferencedObjects(MetaModel.Compiler.CompileInfo info)
        {            
            foreach (var item in this.m_children)
            {
                item.GetReferencedObjects(info);
            }
        }    

        public void Compile(
            CodeStatementCollection parseFunction,
            MetaModel.Compiler.CompileInfo info,
            CodeTypeMemberCollection localVariablesCollection)
        {                        
            //pridaj komentar
            parseFunction.Add(new CodeCommentStatement("sequence .... .... .... .... ...."));
            //usporiadaj deti
            this.m_children.Sort(SequenceChild.CompareBySeqNr);
            //skompiluj deti
            foreach (var item in this.m_children)            
                item.Compile(parseFunction, info, localVariablesCollection);                        
        }
    }
}
