﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MetaModel.Model.DataSets
{
	public class ObjectReferenceLoadCache
	{
		public delegate void registerReferenceDel(ObjectReferenceLoadCache cache);
		public static registerReferenceDel RegisterReference;
		public static registerReferenceDel RegisterReferencedObject;

		//public delegate void registerReferenceDel(ObjectReferenceLoadCache cache);

		List<ObjectReference> m_references = new List<ObjectReference>();
		Dictionary<Guid, ObjectBase> m_referencedObjects = new Dictionary<Guid, ObjectBase>();

		public Dictionary<Guid, ObjectBase> ReferencedObjects
		{
			get { return this.m_referencedObjects; }
		}

		public List<ObjectReference> References
		{
			get { return this.m_references; }
		}

		public static void ParseReferences(ObjectReferenceLoadCache cache)
		{
			if (ObjectReferenceLoadCache.RegisterReference != null)
				ObjectReferenceLoadCache.RegisterReference(cache);
			if (ObjectReferenceLoadCache.RegisterReferencedObject != null)
				ObjectReferenceLoadCache.RegisterReferencedObject(cache);

			foreach (var item in cache.m_references)
			{
				item.ParseReference(cache);
			}
		}
		public static void ParseReferences()
		{
			ObjectReferenceLoadCache cache = new ObjectReferenceLoadCache();
			ObjectReferenceLoadCache.ParseReferences(cache);
		}

		// overload operator +
		public static ObjectReferenceLoadCache operator +(ObjectReferenceLoadCache a, ObjectReferenceLoadCache b)
		{
			ObjectReferenceLoadCache retVal = new ObjectReferenceLoadCache();
			retVal.m_references.AddRange(a.m_references);
			retVal.m_references.AddRange(b.m_references);

			foreach (var item in a.m_referencedObjects)
				retVal.m_referencedObjects.Add(item.Key, item.Value);
			foreach (var item in b.m_referencedObjects)
			{
				if (!(retVal.m_referencedObjects.ContainsKey(item.Key)))
					retVal.m_referencedObjects.Add(item.Key, item.Value);
			}
			return retVal;
		}

	}
}
