﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace MetaModel.Model.DataSets
{
    public class Condition : ObjectBase
    {
        CustomCode m_customCode;
        LengthInstance m_lengthInstance;
        ReferencedInstance m_referencedInstance;
        CyclicCondition m_cyclicCondition;

        public Condition()
        { }
        public Condition(XmlNode node)
            : base(node)
        { }

        #region Public Interface
        public CustomCode CustomCode
        {
            get { return m_customCode; }
            set { m_customCode = value; }
        }
        public LengthInstance LengthInstance
        {
            get { return m_lengthInstance; }
            set { m_lengthInstance = value; }
        }
        public ReferencedInstance ReferencedInstance
        {
            get { return m_referencedInstance; }
            set { m_referencedInstance = value; }
        }
        public CyclicCondition CyclicCondition
        {
            get { return m_cyclicCondition; }
            set { m_cyclicCondition = value; }
        } 
        #endregion

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Condition.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //custom code
            if (this.m_customCode != null)
                this.m_customCode.SaveToXml(this.currentNode);
            //LengthInstance
            if (this.m_lengthInstance != null)
                this.m_lengthInstance.SaveToXml(this.currentNode);
            //ReferencedInstance
            if (this.m_referencedInstance != null)
                this.m_referencedInstance.SaveToXml(this.currentNode);
            //CyclicCondition
            if (this.m_cyclicCondition != null)
                this.m_cyclicCondition.SaveToXml(this.currentNode);            
        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //custom code
            XmlNode childNode = node[CustomCode.NodeName];
            if (childNode != null)
                this.m_customCode = new CustomCode(childNode);
            //LengthInstance
            XmlNode refObjNode = node[LengthInstance.NodeName];
            if (refObjNode != null)
                this.m_lengthInstance = new LengthInstance(refObjNode);
            //ReferencedInstance
            XmlNode refInstNode = node[ReferencedInstance.NodeName];
            if (refInstNode != null)
                this.m_referencedInstance = new ReferencedInstance(refInstNode);
            //CyclicCondition
            XmlNode cyclNode = node[CyclicCondition.NodeName];
            if (cyclNode != null)
                this.m_cyclicCondition = new CyclicCondition(cyclNode);              
        }
        public static new string NodeName = "Condition";


        internal void GetReferencedObjects(MetaModel.Compiler.CompileInfo info)
        {
            if (this.m_referencedInstance != null)
                info.ReferencedObjectList.Add(this.m_referencedInstance.Reference.ReferencedGuid);
            if (this.m_lengthInstance != null)
                info.ReferencedObjectList.Add(this.m_lengthInstance.Reference.ReferencedGuid);
        }
    }
}
