﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.CodeDom;

namespace MetaModel.Model.DataSets
{
    public class Choice : ObjectBase, ISequenceChild, IChild
    {
        Condition m_condition;
        List<Case> m_cases = new List<Case>();

        public Choice()
        { }
        public Choice(XmlNode node)
            : base(node)
        { }

        public Condition Condition
        {
            get { return m_condition; }
            set { m_condition = value; }
        }
        public List<Case> Cases
        {
            get { return m_cases; }
            set { m_cases = value; }
        }

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Choice.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //condition
            if (this.m_condition != null)
                this.m_condition.SaveToXml(this.currentNode);

            //ulozim Cases
            foreach (var item in this.m_cases)
                item.SaveToXml(this.currentNode);
        }

        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            XmlNode conditionNode = node[Condition.NodeName];
            if (conditionNode != null)
                this.m_condition = new Condition(conditionNode);

            //children
            XmlNodeList cases = node.SelectNodes(Case.NodeName);
            foreach (XmlNode item in cases)
                this.m_cases.Add(new Case(item));
        }
        public static new string NodeName = "Choice";

        public void GetReferencedObjects(MetaModel.Compiler.CompileInfo info)
        {
            if (this.m_condition != null)
                this.m_condition.GetReferencedObjects(info);
            foreach (var item in this.m_cases)
            {
                item.GetReferencedObjects(info);
            }
        }

        public void Compile(CodeStatementCollection parseFunction,
            MetaModel.Compiler.CompileInfo info,
            CodeTypeMemberCollection localVariablesCollection)
        {
            //kuknem ci nemam cyclic condition
            //ak mam tak vytvorim do while container

            parseFunction.Add(new CodeCommentStatement("choice .... .... .... ...."));

            CodeStatementCollection statementContainer = parseFunction;
            if (this.m_condition.CyclicCondition != null)
            {
                CodeIterationStatement iterationStatement = new CodeIterationStatement();
                iterationStatement.TestExpression =
                    new CodeSnippetExpression(this.m_condition.CyclicCondition.Function);
                parseFunction.Add(iterationStatement);
                statementContainer = iterationStatement.Statements;
            }

            if (this.m_condition.LengthInstance != null)
            {
                CodeIterationStatement iterationStatement = new CodeIterationStatement();
                Item refItem = this.m_condition.LengthInstance.Reference.ReferencedObject as Item;

                iterationStatement.TestExpression =
                    new CodeSnippetExpression("this." + refItem.MenoLokalnejPremennej + ".Value "
                        + this.m_condition.LengthInstance.SubReference + " > tmpLength");
                statementContainer.Add(iterationStatement);
                statementContainer = iterationStatement.Statements;
            }

            //urcuje ake pole dat sa kontroluje
            string testExpression = null, customCodeTest = null;

            if (this.m_condition.ReferencedInstance != null)
            {
                ReferencedInstance inst = this.m_condition.ReferencedInstance;
                Item refItem = inst.Reference.ReferencedObject as Item;

                testExpression =
                    "this." + refItem.MenoLokalnejPremennej + this.m_condition.ReferencedInstance.SubReference;
            }
            if (this.m_condition.CustomCode != null)
            {
                CustomCode code = this.m_condition.CustomCode;
                testExpression = code.Function;
            }


            this.m_cases.Sort(Case.OrderByValue);
            foreach (var item in this.m_cases)
            {
                if (item.Value != null)
                {
                    CodeConditionStatement condition = new CodeConditionStatement();
                    CodeSnippetExpression test;
                    if (customCodeTest != null)
                    {
                        StringBuilder sb = new StringBuilder();
                        sb.AppendFormat(testExpression, item.ValueString);
                        test = new CodeSnippetExpression(sb.ToString());
                    }
                    else
                        test = new CodeSnippetExpression(
                           "compareData(" + testExpression + ", new byte[] {" + item.ValueString + "})");
                    condition.Condition = test;
                    statementContainer.Add(condition);
                    item.Children.Compile(condition.TrueStatements, info, localVariablesCollection);
                    statementContainer = condition.FalseStatements;
                }
                else
                {
                    //je to default a teda posledna moznost
                    item.Children.Compile(statementContainer, info, localVariablesCollection);
                }

            }

        }

    }
}
