﻿using System;
///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader
{
    /// <summary>
    /// Nese informace o provideru.
    /// </summary>
    public class ProviderInfo
    {
        /// <summary>
        /// Jmeno provideru.
        /// </summary>
        private string name;

        /// <summary>
        /// Typ modulace.
        /// </summary>
        private EModulationType modulation;

        /// <summary>
        /// Pozadovana sirka pasma.
        /// </summary>
        private float bw;

        /// <summary>
        /// Datovy typ provideru.
        /// </summary>
        private Type typ;

        /// <summary>
        /// Konstruktor urceny hlavne pro vytvoreni informace o protocol provideru.
        /// </summary>
        /// <param name="name">Jmeno provideru.</param>
        /// <param name="modulation">Typ modulace</param>
        /// <param name="typ">Datovy typ</param>
        /// <param name="bw">Sirka pasma v Hz</param>
        public ProviderInfo(string name, EModulationType modulation, Type typ, float bw)
        {
            this.modulation = modulation;
            this.name = name;
            this.typ = typ;
            this.bw = bw;
        }

        /// <summary>
        /// Konstruktor urceny hlavne pro vytvareni informace o demod provideru.
        /// </summary>
        /// <param name="name">Jmeno provideru</param>
        /// <param name="modulation">Typ modulace</param>
        /// <param name="typ">Datovy typ</param>
        public ProviderInfo(string name, EModulationType modulation, Type typ)
            : this(name, modulation, typ, 0)
        {
        }

        /// <summary>
        /// Konstruktor urceny hlavne pro vytvateni informace o filter provideru.
        /// </summary>
        /// <param name="name">Jmeno provideru</param>
        /// <param name="typ">Datovy typ provideru</param>
        public ProviderInfo(string name, Type typ)
            : this(name, EModulationType.MT_NOTHING, typ)
        {
        }

        /// <summary>
        /// Jmeno provideru.
        /// </summary>
        public string Name
        {
            get { return this.name; }
        }

        /// <summary>
        /// Typ pozadovane modulace.
        /// </summary>
        public EModulationType ModulationType
        {
            get { return this.modulation; }
        }

        /// <summary>
        /// Datovy typ.
        /// </summary>
        public Type Typ
        {
            get { return this.typ; }
        }

        /// <summary>
        /// Sirka pasma
        /// </summary>
        public float Bw
        {
            get { return this.bw; }
        }
    }
}
