﻿///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader
{
    /// <summary>
    /// Fazova a kvadraturni slozka signalu (I/Q).
    /// </summary>
    public class IQData
    {
        /// <summary>
        /// Fazova slozka.
        /// </summary>
        private double inPhase;

        /// <summary>
        /// Kvadraturni slozka.
        /// </summary>
        private double quadrature;

        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="i">Fazova slozka.</param>
        /// <param name="q">Kvadraturni slozka.</param>
        public IQData(double i, double q)
        {
            this.inPhase = i;
            this.quadrature = q;
        }

        /// <summary>
        /// Fazova slozka.
        /// </summary>
        public double I
        {
            get { return this.inPhase; }
        }

        /// <summary>
        /// Kvadraturni slozka.
        /// </summary>
        public double Q
        {
            get { return this.quadrature; }
        }
    }
}
