﻿using Loaders.IQLoader.ProviderBases;
using Loaders.IQLoader.ProviderInterfaces;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader.Embeded
{
    /// <summary>
    /// Vychozi filtr. Jednoduse kopiruje vstup na vystup.
    /// </summary>
    public class DefaultFilter : FilterProviderBase
    {
        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="settings">Nastaveni pluginu.</param>
        /// <param name="dataProvider">Reference na data provider.</param>
        /// <exception cref="ArgumentNullException">Pokud je nektery z parametru null.</exception>
        public DefaultFilter(PluginSettings settings, IQDataProvider dataProvider)
            : base(settings, dataProvider)
        {
        }

        /// <summary>
        /// Vraci novy I/Q bod ze vstupniho proudu dat.
        /// </summary>
        /// <returns>Vraci novy I/Q bod ze vstupniho proudu dat.</returns>
        /// <exception cref="EndOfStreamException">Jakmile je dosazeno konce souboru.</exception>
        public override IQData getIQPoint()
        {
            return this.dataProvider.getIQPoint();
        }

        /// <summary>
        /// Vraci nazev filtru.
        /// </summary>
        /// <returns>Vraci nazev filtru.</returns>
        public static new string getFilterName()
        {
            return "Výchozí filtr";
        }
    }
}
