﻿using System;
using System.IO;
using Loaders.IQLoader.ProviderBases;
using Loaders.IQLoader.ProviderInterfaces;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Testovaci Demodulation provider pro sit MPT-1327.
///

namespace Loaders.IQLoader.mptDemod
{
    /// <summary>
    /// Testovaci Demodulation provider pro mtp 1327 - FSK demodulace
    /// </summary>
    public class TestdemodProvider : DemodulationProviderBase
    {
        private StreamReader f = null;

        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="settings">Objekt s nastavenim pluginu.</param>
        /// <param name="filterProvider">Instance filter provideru.</param>
        /// <exception cref="ProviderInitializationException">Pokud dojde pri inicializaci k chybe.</exception>
        /// <exception cref="ArgumentNullException">Pokud je nektery z parametru null.</exception>        
        public TestdemodProvider(PluginSettings settings, IQDataProvider filterProvider)
            : base(settings, filterProvider)
        {
            try
            {
                f = new StreamReader(new FileStream("vstup.txt", FileMode.Open, FileAccess.Read));
            }
            catch (FileNotFoundException)
            {
                throw new ProviderInitializationException("Soubor nenalezen! Pomocný demodulátor potřebuje soubor \"vstup.txt\" s bitovými vzorky, umístěný v pracovním adresáři programu.");
            }
            catch (IOException ex)
            {
                throw new ProviderInitializationException("Nelze otevrit soubor.\n" + ex.Message);
            }
            catch (ArgumentNullException ex)
            {
                throw new ProviderInitializationException("Nebyla nastavena cesta k souboru. (" + ex.Message + ")");
            }
        }

        /// <summary>
        /// Vraci dalsi bitovy vzorek demodulovany ze vstupniho toku IQ bodu.
        /// </summary>
        /// <returns>1 nebo 0</returns>
        /// <exception cref="EndOfStreamException">V pripade dosazeni konce dat.</exception>   
        public override byte getBit()
        {
            int data;
            if ((data = this.f.Read()) > 0)
            {
                if (data == '0' || data == '1')
                    return (byte)(data - '0');
                else
                {
                    this.f.Close();
                    throw new FileFormatException("\"vstup.txt\" obsahuje chybu.");
                }
            }
            else
            {
                this.f.Close();
                throw new EndOfStreamException();
            }
        }

        /// <summary>
        /// Vraci nazev provideru.
        /// </summary>
        /// <returns>Vraci nazev provideru.</returns>
        public static new string getDemodName()
        {
            return "Testovací demodulátor";
        }

        /// <summary>
        /// Vraci typ modulace
        /// </summary>
        /// <returns>Vraci typ modulace.</returns>
        public static new EModulationType getModulationType()
        {
            return EModulationType.MT_FSK;
        }
    }
}
