﻿using System;
using Loaders.IQLoader.ProviderBases;
using Loaders.IQLoader.ProviderInterfaces;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Demodulation provider pro sit MPT-1327.
///

namespace Loaders.IQLoader.mpt1327FSKdemod
{
    /// <summary>
    /// FSK demodulator pro MPT-1327.
    /// </summary>
    public class mpt1327FSKdemod : DemodulationProviderBase
    {
        /// <summary>
        /// Predchozi I/Q bod.
        /// </summary>
        IQData oldIq = null;

        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="settings">Objekt s nastavenim pluginu.</param>
        /// <param name="filterProvider">Instance filter provideru.</param>
        /// <exception cref="ProviderInitializationException">Pokud dojde pri inicializaci k chybe.</exception>
        /// <exception cref="ArgumentNullException">Pokud je nektery z parametru null.</exception>        
        public mpt1327FSKdemod(PluginSettings settings, IQDataProvider filterProvider)
            : base(settings, filterProvider)
        {
        }

        /// <summary>
        /// Vraci dalsi bitovy vzorek odvozeny ze vstupniho toku IQ bodu.
        /// </summary>
        /// <returns>1 nebo 0</returns>
        /// <exception cref="EndOfStreamException">V pripade dosazeni konce dat.</exception>   
        public override byte getBit()
        {
            // Pokud jsme zavolani poprve, musime nacist dva body.
            if (this.oldIq == null)
            {
                this.oldIq = this.filterProvider.getIQPoint();
            }
            IQData pomIq = this.filterProvider.getIQPoint();
            double derivace = Math.Atan((oldIq.I * pomIq.Q - oldIq.Q * pomIq.I) / (oldIq.I * pomIq.I + oldIq.Q * pomIq.Q));
            return 0;
        }

        /// <summary>
        /// Vraci nazev provideru.
        /// </summary>
        /// <returns>Vraci nazev provideru.</returns>
        public static new string getDemodName()
        {
            return "FSK demodulátor pro MPT-1327";
        }

        /// <summary>
        /// Vraci typ modulace
        /// </summary>
        /// <returns>Vraci typ modulace.</returns>
        public static new EModulationType getModulationType()
        {
            return EModulationType.MT_FSK;
        }
    }
}
