﻿using System;
using AnalyzeThisForms.Components;
using ObjectModel.InformationElements;
using ObjectModel.Protocols;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Protocol provider pro sit MPT-1327.
///

namespace Loaders.IQLoader.mpt1327
{
    /// <summary>
    /// Protocol factory pro MPT-1327.
    /// </summary>
    public class Mpt1327ProtocolFactory : ProtocolFactoryBase
    {
        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="info_"></param>
        public Mpt1327ProtocolFactory(ProgramInfo info_)
        {
            this.info = info_;
        }

        /// <summary>
        /// Parsuje dany protokol.
        /// </summary>
        /// <param name="rootProtocol">Protokol nejnizsi urovne.</param>
        public override void ParseProtocol(InformationElementBase rootProtocol)
        {
            Object newItem = null;
            String newItemName = null;            
            if (((rootProtocol.DataColl.Data[0] & 0x80) == 0x80)
                && ((rootProtocol.DataColl.Data[2] & 0x04) == 0x00))
            {
                newItemName = "mpt1327.GTC";
                newItem = this.info.GetObject("Protocols.mptTest.GTC", rootProtocol, 0, 0);
            }
            else if (((rootProtocol.DataColl.Data[0] & 0x80) == 0x80)            
                && ((rootProtocol.DataColl.Data[2] & 0x04) == 0x04)
				&& ((rootProtocol.DataColl.Data[3] & 0x04) == 0x00))
            {
                newItemName = "mpt1327.Aloha";
                newItem = this.info.GetObject("Protocols.mptTest.Aloha", rootProtocol, 0, 0);
            }
			else if (((rootProtocol.DataColl.Data[0] & 0x80) == 0x80)
				&& ((rootProtocol.DataColl.Data[2] & 0x04) == 0x04)
				&& ((rootProtocol.DataColl.Data[3] & 0x04) == 0x04))
			{
				newItemName = "mpt1327.Ack";
				newItem = this.info.GetObject("Protocols.mptTest.Ack", rootProtocol, 0, 0);
			}
            else if ((rootProtocol.DataColl.Data[0] & 0x80) == 0x00)
            {
                newItemName = "mpt1327.CCSC";
                newItem = this.info.GetObject("Protocols.mptTest.CCSC", rootProtocol, 0, 0);
            }
            
            if (newItem != null)
                rootProtocol.Items.Add(newItemName, newItem);
        }

        /// <summary>
        /// Seznam podporovanych protokolu.
        /// </summary>
        public override string[] ParsedProtocols
        {
            get
            {
                return new string[] { "Protocols.mptTest.mpt1327" };
            }
        }

        /// <summary>
        /// Jmeno protocol factory.
        /// </summary>
        public override string Name
        {
            get { return "MPT-1327 Protocol Factory"; }
        }
    }
}
