﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using ObjectModel.Protocols;
using ObjectModel.InformationElements;

namespace ObjectModel.Loaders
{
    public class GsmXmlLoader : LoaderBase
    {
        XmlDocument document = null;
        XmlNode currentNode = null;

        public GsmXmlLoader()
        { }
        public GsmXmlLoader(string fileName)
        {
            this.document = new XmlDocument();
            this.document.Load(fileName);
        }

		public override string Name
		{
			get
			{
				return "Gsm Xml Loader";
			}
		}

        public override bool OpenDevice()
        {
            OpenFileDialog openDialog = new OpenFileDialog();
            openDialog.Filter = "Xml files (*.xml)|*.xml|All files (*.*)|*.*";
            openDialog.FilterIndex = 1;
            openDialog.RestoreDirectory = true;
            openDialog.Multiselect = false;

            if (openDialog.ShowDialog() == DialogResult.OK)
            {
                string fileName = openDialog.FileName;
                this.document = new XmlDocument();
                this.document.Load(fileName);

                return true;
            }
            return false;
        }
        public override void CloseDevice()
        {
            this.document = null;            
        }
        public override InformationElementBase GetNextPacket()
        {
            if (this.currentNode == null)
            {
                currentNode = document["dump"].FirstChild;
            }
            else
            {
                currentNode = currentNode.NextSibling;
            }

            if (currentNode != null)
            {
                InformationElementBase packet = new InformationElementBase();
                foreach (XmlAttribute attr in currentNode.Attributes)
                {
                    if (attr.Name == "data")
                        packet.DataColl = new DataCollection(ParserHelper.StrToByteArray(attr.Value));
                    else
                        packet.Items.Add(attr.Name, attr.Value);
                }
                return packet;
            }
            return null;            
        }

        public override ProtocolFactoryBase getProtocolFactory(AnalyzeThisForms.Components.ProgramInfo info_)
        {
            return new GsmProtocols.ProtocolFactory(info_);
        }
    }
}
