﻿using System;
using ObjectModel.InformationElements;
using ObjectModel.Loaders;
using ObjectModel.Renderers;
using System.Runtime.Remoting.Metadata.W3cXsd2001;

namespace ConsoleTestProject
{
    class Program
    {
        [STAThread]
        static void Main(string[] args)
        {
                                                
            GsmXmlLoader loader = new GsmXmlLoader();
            if (loader.OpenDevice())
            {
                GsmProtocols.ProtocolFactory factory = new GsmProtocols.ProtocolFactory(new AnalyzeThisForms.Components.ProgramInfo());

                InformationElementBase p;
                do
                {
                    p = loader.GetNextPacket();
                    if (p != null && p.Data != null)
                    {
                        factory.ParseProtocol(p);
                        p.SetRendererRecursive(new ConsoleTextRenderer());

                        p.RenderData(null);
                        p.RenderInformationElements(0);
                        Console.WriteLine();

                        Console.WriteLine("-----");
                    }

                } while (p != null);
            }
        }

        private static void createTestMeta()
        {
            throw new NotImplementedException();
        }
    }
}
