﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using AnalyzeThisForms.Components;
using System.IO;

namespace AnalyzeThisForms
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

			//start and load core
			ProgramInfo mainInfo = new ProgramInfo();
			mainInfo.LoadSettings(Application.CommonAppDataPath);
			mainInfo.LoadPravidla(mainInfo.Settings.PravidlaDirectory);
			mainInfo.LoadPlugins(Path.Combine(Application.StartupPath, "Plugins"));
			//start main form
			mainForm frm = new mainForm(mainInfo);			
			Application.Run(frm);

			mainInfo.SaveSettings(Application.CommonAppDataPath);
        }
    }
}
