﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AnalyzeThisForms.Panels
{
	public delegate void StavChangedEventHandler(AnalyzeThisForms.Panels.SubPanelHeader.State state);
	public partial class SubPanelHeader : UserControl
	{
		public enum State
		{
			Closed,
			Open
		}

		private State stav = State.Open;
		public event StavChangedEventHandler StavChanged;

		public SubPanelHeader()
		{
			InitializeComponent();
			PaintGradient();
		}	

		private void PaintGradient()
		{
			System.Drawing.Drawing2D.LinearGradientBrush gradBrush;
			gradBrush =
			  new System.Drawing.Drawing2D.LinearGradientBrush(new
			  Point(0, 0), new Point(this.Width, this.Height),
			  Color.LightSteelBlue, Color.Lavender);

			Bitmap bmp = new Bitmap(this.Width, this.Height);

			Graphics g = Graphics.FromImage(bmp);
			g.FillRectangle(gradBrush, new Rectangle(0, 0,
							this.Width, this.Height));
			this.BackgroundImage = bmp;
			this.BackgroundImageLayout = ImageLayout.Stretch;
		}

		public string HeaderText
		{
			get { return this.lblHeader.Text; }
			set { this.lblHeader.Text = value; }
		}
		public State Stav
		{
			get { return stav; }
			set
			{
				stav = value;
				this.changeStatePicture();
			}
		}
		public bool ImageVisible
		{
			get { return this.pictureBox1.Visible; }
			set { this.pictureBox1.Visible = value; }
		}

		private void changeStatePicture()
		{
			switch (this.stav)
			{
				case State.Closed:
					this.pictureBox1.Image = global::AnalyzeThisForms.Properties.Resources.nav_down_green;
					break;
				default:
				case State.Open:
					this.pictureBox1.Image = global::AnalyzeThisForms.Properties.Resources.nav_up_green;
					break;
									
			}
		}

		private void pictureBox1_Click(object sender, EventArgs e)
		{
			if (this.stav == State.Open)
				this.Stav = State.Closed;
			else
				this.Stav = State.Open;
			this.changeStatePicture();

			if (this.StavChanged != null)
				this.StavChanged(this.stav);
		}
		
	}
}
