﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MetaModel.Model;
using MetaModel.Model.InformationSubElementNs;
using MetaModel.Model.InformationElementNs;

namespace AnalyzeThisForms.Panels
{
	internal enum ModelsTree_Images
	{
		Namespace,
		Element,
		SubElement,
		Compo_new,
		Compo_red,
		Compo_Yel,
		Choice,
		Case,
		CaseDefault,
		Sequence,
		Meaning,
		Folder,
		FolderClose
	}
	public delegate void NodeEventHandler(TreeNode node);

	public partial class ModelsTree : PanelBase
	{
		private List<ProtocolModel> loadedModels = new List<ProtocolModel>();

		public ModelsTree()
		{
			InitializeComponent();
			this.Dock = DockStyle.Fill;
			this.AddModel(null);
		}

		public enum nodeType
		{
			folder,
			newSubElement,
			newElement,
			newModel
		}

		public List<ProtocolModel> LoadedModels
		{
			get { return loadedModels; }
		}

		public void ShowModels(List<ProtocolModel> models_)
		{
			foreach (var item in models_)
			{
				this.addModelToTree(item);
			}
		}
		public void AddModel(ProtocolModel model)
		{
			this.addModelToTree(model);
		}
		public void ClearModels()
		{
			this.treeView1.Nodes.Clear();
			this.loadedModels.Clear();
		}

		private void addModelToTree(ProtocolModel model)
		{
			foreach (var item in this.loadedModels)
			{
				if (item.Data.Namespace == model.Data.Namespace)
					return;
			}

			this.treeView1.BeginUpdate();

			TreeNode node = new TreeNode();
			node.Tag = model;
			node.ImageIndex = (int)ModelsTree_Images.Namespace;
			node.SelectedImageIndex = (int)ModelsTree_Images.Namespace;
			this.treeView1.Nodes.Add(node);

			if (model != null)
			{
				node.Text = model.Data.Namespace;
				this.loadedModels.Add(model);
			}
			else
			{
				node.Text = "New Namespace";
				node.Tag = nodeType.newModel;
				node.ForeColor = Color.Gray;
			}

			TreeNode subElementsFolder = this.createFolderNode(node, "Sub Elements");
			TreeNode elementsFolder = this.createFolderNode(node, "Elements");
			if (model != null)
			{
				model.Data.SubElements.Sort(this.compareByName);
				foreach (InformationSubElement subElem in model.Data.SubElements)
				{
					this.addSubElementToTree(subElem, subElementsFolder);
				}
				this.addSubElementToTree(null, subElementsFolder);
				subElementsFolder.Expand();


				model.Data.Elements.Sort(this.compareByName);
				foreach (InformationElement elem in model.Data.Elements)
				{
					this.addElementToTree(elem, elementsFolder);
				}
				this.addElementToTree(null, elementsFolder);
				elementsFolder.Expand();
			}
			this.treeView1.EndUpdate();
		}
		private bool compareByNamespace(ProtocolModel a, ProtocolModel b)
		{
			return a.Data.Namespace == b.Data.Namespace;
		}

		private TreeNode createFolderNode(TreeNode parentNode, string text)
		{
			TreeNode node = new TreeNode();
			node.Text = text;
			node.Tag = nodeType.folder;
			node.ImageIndex = (int)ModelsTree_Images.Folder;
			node.SelectedImageIndex = (int)ModelsTree_Images.Folder;
			node.ForeColor = Color.DimGray;			
			parentNode.Nodes.Add(node);

			return node;
		}

		private void addElementToTree(InformationElement elem, TreeNode parentNode)
		{
			TreeNode node = CreateElementTreeNode(elem);
			parentNode.Nodes.Add(node);
		}
		public static TreeNode CreateElementTreeNode(InformationElement elem)
		{
			TreeNode node = new TreeNode();
			if (elem != null)
			{
				node.Text = elem.Name;
				node.Tag = elem;
			}
			else
			{
				node.Text = "New Element";
				node.ForeColor = Color.Gray;
				node.Tag = nodeType.newElement;
			}
			node.ImageIndex = (int)ModelsTree_Images.Element;
			node.SelectedImageIndex = (int)ModelsTree_Images.Element;
			return node;
		}
		private void addSubElementToTree(InformationSubElement subElem, TreeNode parentNode)
		{
			TreeNode node = CreateSubElementTreeNode(subElem);
			parentNode.Nodes.Add(node);
		}
		public static TreeNode CreateSubElementTreeNode(InformationSubElement subElem)
		{
			TreeNode node = new TreeNode();

			if (subElem != null)
			{
				node.Text = subElem.Name;
				node.Tag = subElem;
			}
			else
			{
				node.Text = "New Sub Element";
				node.ForeColor = Color.Gray;
				node.Tag = nodeType.newSubElement;
			}
			node.ImageIndex = (int)ModelsTree_Images.SubElement;
			node.SelectedImageIndex = (int)ModelsTree_Images.SubElement;
			return node;
		}

		private int compareByName(MetaModel.ObjectBase a, MetaModel.ObjectBase b)
		{
			return a.Name.CompareTo(b.Name);
		}	

		public event NodeEventHandler SelectedNodeChanged;
		private void handleSelectedNode(TreeNode selectedNode)
		{
			//throw new NotImplementedException();
			if (this.SelectedNodeChanged != null)
			{
				this.SelectedNodeChanged(selectedNode);
			}
		}

		private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
		{
			this.handleSelectedNode(e.Node);
		}

		private void treeView1_KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Delete || e.KeyCode == Keys.Back)
			{
				TreeNode node = this.treeView1.SelectedNode;
				if (node != null)
				{
					if (node.Tag is ProtocolModel)
					{
						this.treeView1.Nodes.Remove(node);
						this.loadedModels.Remove(node.Tag as ProtocolModel);
					}
					else if (node.Tag is InformationSubElement)
					{
						InformationSubElement subElem = node.Tag as InformationSubElement;
						subElem.Parent.SubElements.Remove(subElem);
						this.treeView1.Nodes.Remove(node);
					}
					else if (node.Tag is InformationElement)
					{
						InformationElement ielem = node.Tag as InformationElement;
						ielem.Parent.Elements.Remove(ielem);
						this.treeView1.Nodes.Remove(node);
					}
				}
			}
		}

		private void ModelsTree_MouseDown(object sender, MouseEventArgs e)
		{
			TreeView lv = (TreeView)sender;
			TreeNode it = lv.GetNodeAt(e.Location);
			if (it != null)
			{
				if (e.Clicks == 1)
				{
					lv.DoDragDrop(it, DragDropEffects.Copy);
				}
				else
				{
					lv.SelectedNode = it;
					//this.handleSelectedNode(it);

				}
			}			

		}

	}
}
