﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MetaModel.Model.InformationElementNs;
using MetaModel.Model.DataSets;

namespace AnalyzeThisForms.Panels
{
	public partial class ElementTree : AnalyzeThisForms.Panels.SubPanelBase
	{
		InformationElement elem;

		public ElementTree()
		{
			InitializeComponent();
			this.subPanelHeader1.ImageVisible = false;

			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ModelsTree));
			ImageList imageList1 = new System.Windows.Forms.ImageList();
			imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.treeView1.ImageList = imageList1;
		}

		public void RenderElementTree(InformationElement elem_)
		{
			this.elem = elem_;
			this.treeView1.BeginUpdate();
			this.treeView1.Nodes.Clear();

			TreeNode nd = new TreeNode();
			nd.Text = elem_.Name;
			nd.ImageIndex = (int)ModelsTree_Images.Element;
			nd.SelectedImageIndex = (int)ModelsTree_Images.Element;
			nd.Tag = elem_;
			this.treeView1.Nodes.Add(nd);
			this.renderChildren(elem_.Children, nd);
			this.treeView1.ExpandAll();
			this.treeView1.EndUpdate();
		}
		private void renderChildren(Children ch, TreeNode parentNd)
		{
			if (ch == null) return;
			if (ch.Child is Sequence)
				this.renderSeq(ch.Child as Sequence, parentNd);
			else
				this.renderChoice(ch.Child as Choice, parentNd);

		}
		private void renderSeq(Sequence s, TreeNode parentNd)
		{
			if (s == null || s.Children == null) return;
			s.Children.Sort(SequenceChild.CompareBySeqNr);
			foreach (SequenceChild child in s.Children)
			{
				if (child.Child is Item)
					this.renderItem(child.Child as Item, parentNd);
				else if (child.Child is Choice)
					this.renderChoice(child.Child as Choice, parentNd);
			}
		}
		private void renderChoice(Choice ch, TreeNode parentNd)
		{
			if (ch == null) return;
			TreeNode choiceNd = new TreeNode();
			choiceNd.Text = "Choice:";
			choiceNd.ImageIndex = (int)ModelsTree_Images.Choice;
			choiceNd.SelectedImageIndex = (int)ModelsTree_Images.Choice;
			choiceNd.Tag = ch;
			parentNd.Nodes.Add(choiceNd);

			foreach (var caseItem in ch.Cases)
			{
				TreeNode caseNd = new TreeNode();
				caseNd.Text = "Case: " + caseItem.ValueRenderString;
				if (caseItem.Value != null)
				{
					caseNd.ImageIndex = (int)ModelsTree_Images.Case;
					caseNd.SelectedImageIndex = (int)ModelsTree_Images.Case;
				}
				else
				{
					caseNd.ImageIndex = (int)ModelsTree_Images.CaseDefault;
					caseNd.SelectedImageIndex = (int)ModelsTree_Images.CaseDefault;
				}
				caseNd.Tag = caseItem;
				choiceNd.Nodes.Add(caseNd);

				this.renderChildren(caseItem.Children, caseNd);
			}
		}
		private void renderItem(Item i, TreeNode parentNd)
		{
			if (i == null) return;
			TreeNode nd = new TreeNode();
			if (i.Reference.ReferencedObject != null)
			{
				nd.Text = i.Name + "[" + i.Reference.ReferencedObject.Name + "]";
				if (i.Reference.ReferencedObject is InformationElement)
					nd.SelectedImageIndex = nd.ImageIndex = (int)ModelsTree_Images.Element;
				else
					nd.SelectedImageIndex = nd.ImageIndex = (int)ModelsTree_Images.SubElement;

			}
			else
			{
				nd.Text = i.Name + "[null]";
				nd.SelectedImageIndex = (int)ModelsTree_Images.Compo_red;
			}

			nd.Tag = i;
			parentNd.Nodes.Add(nd);
		}

		private void treeView1_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.Serializable))
			{
				e.Effect = DragDropEffects.Copy;
			}
			else
			{
				e.Effect = DragDropEffects.None;
			}
		}

		private void treeView1_DragDrop(object sender, DragEventArgs e)
		{
			TreeNode oldNode;

			Point p = new Point();
			p.X = e.X;
			p.Y = e.Y - 16;			
			p = this.PointToClient(p);
			oldNode = this.treeView1.GetNodeAt(p);

			TreeNode newNode = e.Data.GetData(typeof(TreeNode)) as TreeNode;

			if (oldNode.Tag == null) return;
			if (oldNode.Tag is InformationElement)
			{
				//je to root
				InformationElement el = oldNode.Tag as InformationElement;
				if (el.Children == null)				
					el.Children = new Children();
				if (el.Children.Child == null)
					el.Children.Child = new Sequence();
				if (el.Children.Child is Sequence)
				{
					Sequence s = el.Children.Child as Sequence;
					MetaModel.ObjectBase newNodeTag = newNode.Tag as MetaModel.ObjectBase;

					SequenceChild sc = new SequenceChild(s.Children.Count, new Item(newNodeTag.Name, newNodeTag));
					s.Children.Add(sc);
				}
			}
			if (oldNode.Tag is Item)
			{

			}
			else if (oldNode.Tag is Choice)
			{

			}
			else if (oldNode.Tag is Case)
			{

			}
			//redraw tree
			this.RenderElementTree(this.elem);

		}
		
	}
}
