﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MetaModel.Model.InformationElementNs;
using MetaModel.Model.DataSets;

namespace AnalyzeThisForms.Panels.Editor
{
	public partial class ElementDetail : AnalyzeThisForms.Panels.PanelBase, IEditorChild
	{
		InformationElement elem;
		TreeNode node;

		public ElementDetail()
		{
			InitializeComponent();
		}
		public ElementDetail(InformationElement elem_, TreeNode node_)
			: this()
		{
			this.elem = elem_;
			this.node = node_;

			this.tbName.Text = elem_.Name;
			this.renderElementTree();
		}

		private void renderElementTree()
		{
			this.elementTree1.RenderElementTree(this.elem);
		}
		

		#region IEditorChild Members

		public void Save()
		{
			if (this.elem != null)
			{
				this.elem.Name = this.tbName.Text;
				//this.elem.Type = (MetaModel.Model.InformationSubElementNs.Type)this.cbType.SelectedItem;			
				if (this.node.Tag is InformationElement)
					this.node.Text = this.tbName.Text;
				else
				{
					//je to novy elem
					if (elem.Name.Length > 0)
					{
						//ak ma vyplnene meno, tak je aj platny
						this.elem.Parent.Elements.Add(this.elem);
						//redraw node paretnNode children
						this.addTreeNode(this.node, this.elem);
					}

				}
			}
		}

		private void addTreeNode(TreeNode treeNode, InformationElement informationElement)
		{
			TreeNode parentNode = treeNode.Nodes[1];
			treeNode = ModelsTree.CreateElementTreeNode(informationElement);

			//najdi index kam sa ma vlozit
			int i;
			for (i = 0; i < parentNode.Nodes.Count; i++)
			{
				TreeNode nd = parentNode.Nodes[i];
				if (nd.Text.CompareTo(treeNode.Text) > 0) break;
			}
			if (i >= parentNode.Nodes.Count - 1)
				i = Math.Max(0, i - 1);
			parentNode.Nodes.Insert(i, treeNode);

		}

		#endregion
	}
}
