﻿using System.IO;
using System.Windows.Forms;
using System.Xml;
using AnalyzeThisForms.Components;
using MetaModel.Compiler;
using MetaModel.Model;
using MetaModel.Model.InformationElementNs;
using MetaModel.Model.InformationSubElementNs;
using MetaModel.Model.DataSets;


namespace AnalyzeThisForms.Panels.Editor
{
	public partial class EditorMainPanel : UserControl
	{
		private ProgramInfo info;

		public EditorMainPanel()
		{
			InitializeComponent();
		}

		public ProgramInfo Info
		{
			get { return info; }
			set
			{
				info = value;
				this.LoadModels();
			}
		}

		public bool loadModel()
		{
			//ukaz dialog
			OpenFileDialog openDialog = new OpenFileDialog();
			openDialog.Filter = "Model files (*.mdl)|*.mdl|All files (*.*)|*.*";
			openDialog.FilterIndex = 1;
			openDialog.RestoreDirectory = true;
			openDialog.Multiselect = false;

			if (openDialog.ShowDialog() == DialogResult.OK)
			{
				string fileName = openDialog.FileName;
				ProtocolModel model = ProtocolModel.LoadFromXml(fileName);
				if (model != null)
				{
					ObjectReferenceLoadCache.ParseReferences();
					//zobraz ho					
					this.modelsTree1.AddModel(model);
				}
				return true;
			}
			return false;
		}

		public void LoadModels()
		{
			if (this.info != null)
			{
				this.modelsTree1.ClearModels();
				this.modelsTree1.AddModel(null);
				string[] files = Directory.GetFiles(this.info.Settings.ModelsDirectory, "*.mdl");
				foreach (var filename in files)
				{
					ProtocolModel model = ProtocolModel.LoadFromXml(filename);
					if (model != null)
					{
						//zobraz ho					
						this.modelsTree1.AddModel(model);
					}
				}
				ObjectReferenceLoadCache.ParseReferences();
			}

		}
		public void SaveModels()
		{
			if (Directory.Exists(this.info.Settings.ModelsDirectory))
				foreach (string file in Directory.GetFiles(this.info.Settings.ModelsDirectory))
				{
					try
					{
						File.Delete(Path.Combine(this.info.Settings.ModelsDirectory, file));
					}
					catch
					{ }
				}
			else
				Directory.CreateDirectory(this.info.Settings.ModelsDirectory);
			foreach (var model in this.modelsTree1.LoadedModels)
			{
				//item
				string filename = Path.Combine(this.info.Settings.ModelsDirectory, model.Data.Namespace + ".mdl");
				XmlDocument modelDoc = model.SaveToXml();
				try
				{
					modelDoc.Save(filename);
				}
				catch
				{ }
			}
		}

		private void modelsTree1_SelectedNodeChanged(TreeNode node)
		{
			this.clearPanel();

			if (node.Tag is ProtocolModel)
			{
				this.showPanel(new ModelDetail(node.Tag as ProtocolModel, node));
			}
			else if (node.Tag is InformationSubElement)
			{
				this.showPanel(new SubElementDetail(node.Tag as InformationSubElement, node));
			}
			else if (node.Tag is InformationElement)
			{
				this.showPanel(new ElementDetail(node.Tag as InformationElement, node));
			}
			else if (node.Tag is ModelsTree.nodeType)
			{
				ModelsTree.nodeType nodeType = (ModelsTree.nodeType)node.Tag;
				switch (nodeType)
				{
					default:
					case ModelsTree.nodeType.folder:
						break;
					case ModelsTree.nodeType.newSubElement:
						this.createNewSubElement(node);
						break;
					case ModelsTree.nodeType.newElement:
						this.createNewElement(node);
						break;
					case ModelsTree.nodeType.newModel:
						this.createNewModel(node);
						break;
				}
			}
		}

		private void createNewModel(TreeNode node)
		{
			ProtocolModel model = new ProtocolModel();
			model.Data = new Data();
			ModelDetail md = new ModelDetail(model, node);
			md.NewProtocol += new AddProtocolModelEventHandler(md_NewProtocol);
			this.showPanel(md);
		}

		void md_NewProtocol(ProtocolModel model)
		{
			this.modelsTree1.AddModel(model);
		}

		private void createNewElement(TreeNode node)
		{
			TreeNode dataNode = node.Parent.Parent;
			Data data = (dataNode.Tag as ProtocolModel).Data;

			InformationElement newElem = new InformationElement(data);
			newElem.Id = System.Guid.NewGuid();
			this.showPanel(new ElementDetail(newElem, dataNode));
		}

		private void createNewSubElement(TreeNode node)
		{
			TreeNode dataNode = node.Parent.Parent;
			Data data = (dataNode.Tag as ProtocolModel).Data;

			InformationSubElement newElem = new InformationSubElement(data);
			newElem.Id = System.Guid.NewGuid();
			this.showPanel(new SubElementDetail(newElem, dataNode));

		}
		private void clearPanel()
		{
			if (this.splitContainer1.Panel2.Controls.Count > 0)
			{
				Control oldControl = this.splitContainer1.Panel2.Controls[0];
				if (oldControl is IEditorChild)
					(oldControl as IEditorChild).Save();
				this.splitContainer1.Panel2.Controls.Clear();
			}
		}
		private void showPanel(Control control)
		{
			control.Dock = DockStyle.Fill;
			this.splitContainer1.Panel2.SuspendLayout();
			this.splitContainer1.Panel2.Controls.Add(control);
			this.splitContainer1.Panel2.ResumeLayout();
		}

		internal bool CompileModel()
		{
			if (this.modelsTree1.LoadedModels.Count == 0)
				return false;

			Compiler compiler = new MetaModel.Compiler.Compiler();            

			foreach (var model in this.modelsTree1.LoadedModels)
			{
				compiler.Models.Add(model);
                //model.SaveToXml().Save(Path.Combine(info.Settings.PravidlaDirectory, model.ToString()+".mdl"));
			}
          
			compiler.CompilerParams[1] = Path.Combine(Application.StartupPath, "ObjectModel.dll");
			string codeDir = Path.Combine(Application.StartupPath, "TestModelCompilation");
			compiler.CodeDir = codeDir;
			if (Directory.Exists(codeDir))
				Directory.Delete(codeDir, true);



			Directory.CreateDirectory(codeDir);
			compiler.AssemblyName = Path.Combine(info.Settings.PravidlaDirectory, info.PravidlaFileName);
			this.info.UnloadPravidla();
			compiler.Compile();

			this.info.LoadPravidla(info.Settings.PravidlaDirectory);
			return true;
		}
	}
}
