/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tspopt;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

/**
 *
 * @author Pavel Bartoš
 */
public class VisualisationPanel extends JPanel{
    private double maxX=0, maxY=0;
    private ArrayList<Chain> chains = null;
    private double actScale=0.1;
    private ArrayList<FlipFlop> flipflops = null;
    private Color ffColor=null;

    public VisualisationPanel() {
        setBackground(Color.white);
        setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
    }

    public void computeBounds() {
        Iterator<FlipFlop> iter = flipflops.iterator();
        while (iter.hasNext()) {
            FlipFlop ff = iter.next();
            if (ff.getX() + ff.getW() > maxX) {
                maxX = ff.getX() + ff.getW();
            }
            if (ff.getY() + ff.getH() > maxY) {
                maxY = ff.getY() + ff.getH();
            }
        }
    }

    public void setScale(double scale, Point mouse) {
        int xPos = (int) (mouse.x * (scale / actScale) - (mouse.x + getLocation().x));
        int yPos = (int) (mouse.y * (scale / actScale) - (mouse.y + getLocation().y));

        actScale = scale;
        setPreferredSize(new Dimension((int) (maxX * actScale), (int) (maxY * actScale)));
        setSize(getPreferredSize());
        setLocation(-xPos, -yPos);
        revalidate();
        repaint();


    }

    public void zoomIn(int steps, Point mouse) {
        setScale(1.2 * steps * actScale, mouse);
    }

    public void zoomOut(int steps, Point mouse) {
        setScale(1 / 1.2 * steps * actScale, mouse);
    }

    public void setFlipFlops(ArrayList<FlipFlop> ff){
        flipflops = ff;
        computeBounds();
        repaint();
    }
    public void setChains(ArrayList<Chain> chain){
        chains = chain;
        repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Iterator<FlipFlop> ffIter = flipflops.iterator();
        while(ffIter.hasNext()){
            ffIter.next().paint(g, actScale, ffColor);
        }

        Iterator<Chain> chIter = chains.iterator();
        while (chIter.hasNext()) {
            chIter.next().paint(g, actScale);
        }
    }

    public void setFFColor(Color color){
        ffColor = color;
        repaint();
    }

    public double getScale(){
        return actScale;
    }


}
