/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * LayoutPanel.java
 *
 * Created on 20.11.2010, 19:07:44
 */

package tspopt;

import com.sun.org.apache.bcel.internal.generic.ARRAYLENGTH;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JColorChooser;
import javax.swing.JTabbedPane;
import org.jdesktop.application.Action;

/**
 *
 * @author Pavel Bartoš
 */
public class LayoutPanel extends javax.swing.JPanel {

    private MouseListener visualisationPanelML = new MouseListener() {

        public void mouseClicked(MouseEvent e) {
            boolean repaint = false;
            if (selectedFF != null) {
                selectedFF.setSelected(false);
                selectedFF = null;
                repaint = true;
            }
            Iterator<FlipFlop> iter = flipflops.iterator();
            FlipFlop ff = null;
            while(iter.hasNext()){
                ff = iter.next();
                if (ff.isInFlipflop(e.getPoint(), visPanel.getScale())){
                    selectedFF = ff;
                    repaint = true;
                    break;
                }
            }
            if (selectedFF != null){
                selectedFF.setSelected(true);
                jLabelSelectedName.setText(selectedFF.getName());
            } else {
                jLabelSelectedName.setText("");
            }
            if (repaint) visPanel.repaint();
        }

        public void mousePressed(MouseEvent e) {
            //throw new UnsupportedOperationException("Not supported yet.");
        }

        public void mouseReleased(MouseEvent e) {
            //throw new UnsupportedOperationException("Not supported yet.");
        }

        public void mouseEntered(MouseEvent e) {
            //throw new UnsupportedOperationException("Not supported yet.");
        }

        public void mouseExited(MouseEvent e) {
            //throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private MouseWheelListener visualisationPanelMWL = new MouseWheelListener() {

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() < 0)
                visPanel.zoomIn(1, e.getPoint());
            else
                visPanel.zoomOut(1, e.getPoint());
        }
    };

    private VisualisationPanel visPanel;
    private ArrayList<FlipFlop> flipflops;
    private ArrayList<Chain> chains;
    private Color ffColor=Color.GRAY;
    private Color bgColor=Color.WHITE;
    private FlipFlop selectedFF = null;
    private JTabbedPane parentTabbedPane = null;

    /** Creates new form LayoutPanel */
    public LayoutPanel(JTabbedPane tabbedPane) {
        initComponents();
        visPanel = new VisualisationPanel();
        visPanel.addMouseListener(visualisationPanelML);
        visPanel.addMouseWheelListener(visualisationPanelMWL);
        jVisualisationScrollPane.setViewportView(visPanel);
        flipflops = new ArrayList<FlipFlop>();
        chains = new ArrayList<Chain>();
        visPanel.setFlipFlops(flipflops);
        visPanel.setChains(chains);
        visPanel.setFFColor(ffColor);
        jLabelFFCount.setText(String.valueOf(flipflops.size()));
        visPanel.setBackground(bgColor);
        this.parentTabbedPane = tabbedPane;
    }
    public void addFlipFlop(FlipFlop ff){
        flipflops.add(ff);
        visPanel.setFlipFlops(flipflops);
        jLabelFFCount.setText(String.valueOf(flipflops.size()));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSetupPanel = new javax.swing.JPanel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jLayoutSetupPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabelFFCount = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jButtonFFColor = new javax.swing.JButton();
        jButtonBgColor = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabelSelectedName = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jTabbedPaneChains = new javax.swing.JTabbedPane();
        jVisualisationScrollPane = new javax.swing.JScrollPane();
        jZoomSlider = new javax.swing.JSlider();

        setName("Form"); // NOI18N

        jSetupPanel.setName("jSetupPanel"); // NOI18N

        jSplitPane1.setDividerLocation(400);
        jSplitPane1.setName("jSplitPane1"); // NOI18N

        jLayoutSetupPanel.setName("jLayoutSetupPanel"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(tspopt.TSPoptApp.class).getContext().getResourceMap(LayoutPanel.class);
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jLabelFFCount.setText(resourceMap.getString("jLabelFFCount.text")); // NOI18N
        jLabelFFCount.setName("jLabelFFCount"); // NOI18N

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(tspopt.TSPoptApp.class).getContext().getActionMap(LayoutPanel.class, this);
        jButtonFFColor.setAction(actionMap.get("ChangeFFColorClicked")); // NOI18N
        jButtonFFColor.setText(resourceMap.getString("jButtonFFColor.text")); // NOI18N
        jButtonFFColor.setName("jButtonFFColor"); // NOI18N

        jButtonBgColor.setAction(actionMap.get("ChangeBgColorClicked")); // NOI18N
        jButtonBgColor.setText(resourceMap.getString("jButtonBgColor.text")); // NOI18N
        jButtonBgColor.setName("jButtonBgColor"); // NOI18N

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N

        jLabelSelectedName.setText(resourceMap.getString("jLabelSelectedName.text")); // NOI18N
        jLabelSelectedName.setName("jLabelSelectedName"); // NOI18N

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N

        jTextField1.setText(resourceMap.getString("jTextField1.text")); // NOI18N
        jTextField1.setName("jTextField1"); // NOI18N

        jButton1.setAction(actionMap.get("setLayoutName")); // NOI18N
        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setName("jButton1"); // NOI18N

        javax.swing.GroupLayout jLayoutSetupPanelLayout = new javax.swing.GroupLayout(jLayoutSetupPanel);
        jLayoutSetupPanel.setLayout(jLayoutSetupPanelLayout);
        jLayoutSetupPanelLayout.setHorizontalGroup(
            jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jLayoutSetupPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jLayoutSetupPanelLayout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 227, Short.MAX_VALUE)
                        .addComponent(jLabelFFCount))
                    .addGroup(jLayoutSetupPanelLayout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 155, Short.MAX_VALUE)
                        .addComponent(jButtonFFColor))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jLayoutSetupPanelLayout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 149, Short.MAX_VALUE)
                        .addComponent(jButtonBgColor))
                    .addGroup(jLayoutSetupPanelLayout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 201, Short.MAX_VALUE)
                        .addComponent(jLabelSelectedName))
                    .addGroup(jLayoutSetupPanelLayout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 214, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE)
                        .addComponent(jButton1)))
                .addContainerGap())
        );
        jLayoutSetupPanelLayout.setVerticalGroup(
            jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jLayoutSetupPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabelFFCount))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jButtonFFColor))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonBgColor)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jLabelSelectedName))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jLayoutSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton1))
                .addContainerGap(21, Short.MAX_VALUE))
        );

        jSplitPane1.setLeftComponent(jLayoutSetupPanel);

        jTabbedPaneChains.setName("jTabbedPaneChains"); // NOI18N
        jSplitPane1.setRightComponent(jTabbedPaneChains);

        javax.swing.GroupLayout jSetupPanelLayout = new javax.swing.GroupLayout(jSetupPanel);
        jSetupPanel.setLayout(jSetupPanelLayout);
        jSetupPanelLayout.setHorizontalGroup(
            jSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 804, Short.MAX_VALUE)
        );
        jSetupPanelLayout.setVerticalGroup(
            jSetupPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 164, Short.MAX_VALUE)
        );

        jVisualisationScrollPane.setName("jVisualisationScrollPane"); // NOI18N

        jZoomSlider.setOrientation(javax.swing.JSlider.VERTICAL);
        jZoomSlider.setName("jZoomSlider"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jVisualisationScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 782, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jZoomSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addComponent(jSetupPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jVisualisationScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 343, Short.MAX_VALUE)
                    .addComponent(jZoomSlider, javax.swing.GroupLayout.DEFAULT_SIZE, 343, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSetupPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

    @Action
    public void ChangeFFColorClicked() {
        Color c = JColorChooser.showDialog(null, "Choose flipflop color", ffColor);
        if (c != null){
            ffColor = c;
            jButtonFFColor.setForeground(c);
            visPanel.setFFColor(c);            
        }
    }

    @Action
    public void ChangeBgColorClicked() {
        Color c = JColorChooser.showDialog(null, "Choose background color", bgColor);
        if (c != null){
            bgColor = c;
            jButtonBgColor.setForeground(c);
            visPanel.setBackground(c);            
        }
    }

    public FlipFlop getFFbyPath(String path) {
        Iterator<FlipFlop> iter = flipflops.iterator();
        FlipFlop ff = null;
        while (iter.hasNext()) {
            ff = iter.next();
            if (ff.getPath().equals(path)) {
                return ff;
            }
        }
        return null;
    }

    public void addChain(Chain ch){
        chains.add(ch);
        jTabbedPaneChains.add(ch);
        visPanel.setChains(chains);
    }
    public void removeChain(Chain ch){
        chains.remove(ch);
        jTabbedPaneChains.remove(ch);
        visPanel.setChains(chains);
    }
    public ArrayList<Chain> getChains(){
        return chains;
    }

    public Chain getChainByName(String chainName){
        Iterator<Chain> iter = chains.iterator();
        Chain ch = null;
        while (iter.hasNext()) {
            ch = iter.next();
            if (ch.getChainName().equals(chainName)) {
                return ch;
            }
        }
        return null;
    }

    public Chain getActualChain() {
        return (Chain) jTabbedPaneChains.getSelectedComponent();
    }

    public VisualisationPanel getVisPanel(){
        return visPanel;
    }

    @Action
    public void setLayoutName() {
        this.setName(jTextField1.getText());

        Component c[] = parentTabbedPane.getComponents();
        int i;
        for (i=0; i<c.length; i++){
            if (c[i] == this) break;
        }
        parentTabbedPane.setTitleAt(i, this.getName());
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButtonBgColor;
    private javax.swing.JButton jButtonFFColor;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabelFFCount;
    private javax.swing.JLabel jLabelSelectedName;
    private javax.swing.JPanel jLayoutSetupPanel;
    private javax.swing.JPanel jSetupPanel;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTabbedPane jTabbedPaneChains;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JScrollPane jVisualisationScrollPane;
    private javax.swing.JSlider jZoomSlider;
    // End of variables declaration//GEN-END:variables

}
