/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * Chain.java
 *
 * Created on 22.11.2010, 15:51:39
 */

package tspopt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;

/**
 *
 * @author Pavel Bartoš
 */
public class Chain extends javax.swing.JPanel implements TableModel{
    private ArrayList<FlipFlop> flipflops = new ArrayList<FlipFlop>();
    private ArrayList<FlipFlop> flipflopsOpt = new ArrayList<FlipFlop>();
    private String name;
    private Color color = Color.RED;
    private Boolean visible = true;
    private VisualisationPanel visPanel;
    static private ArrayList<String> names = new ArrayList<String>();
    private boolean autoOptimize = true;
    private ArrayList<TableModelListener> tableListeners = new ArrayList<TableModelListener>();

    /** Creates new form Chain */
    public Chain(String name, VisualisationPanel visPanel) {
        initComponents();
        this.name = name;
        this.setName(name);
        setLenghtLabel(0);
        this.visPanel = visPanel;
        button1.setBackground(color);
        names.add(name);
    }

    static private boolean isNameFree(String name){
        Iterator<String> iter = names.iterator();
        while(iter.hasNext()){
            if (iter.next().equals(name)) return false;
        }
        return true;
    }

    @Override
    protected void finalize() throws Throwable{
        Iterator<String> iter = names.iterator();
        while(iter.hasNext()){
            String str = iter.next();
            if (str.equals(this.name)) names.remove(str);
        }
        super.finalize();
    }

    public Boolean getVisible() {
        return visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Color getColor() {
        return color;
    }

    public void setColor(Color color) {
        this.color = color;
    }


    public void addFlipFlop(FlipFlop ff){
        flipflops.add(ff);
        setLenghtLabel(getLenght());
    }

    public void removeFlipFlop(FlipFlop ff){
        flipflops.remove(ff);
        setLenghtLabel(getLenght());
    }

    private void setLenghtLabel(double l){
        jLabelLenght.setText("Lenght: ".concat(Double.toString(l)).concat("    # of cells: ").concat(Integer.toString(flipflops.size())));
    }
    private void setOptLenghtLabel(double l){
        jLabelOptimizedLen.setText("Optimized lenght: ".concat(Double.toString(l)));
    }

    public String getChainName(){
        return name;
    }
    public void setChainName(String newName){
        names.remove(this.name);
        names.add(newName);
        this.name = newName;
        setName(newName);
    }

    public void paint(Graphics g, double scale){
        if (!visible) {
            return;
        }
        ArrayList<FlipFlop> ffArray;
        if (jRadioButtonOriginal.isSelected())
            ffArray = flipflops;
        else
            ffArray = flipflopsOpt;

        int pointsCount;
        int xPoints[];
        int yPoints[];
        if (jRadioEuclidean.isSelected()) {
            pointsCount = ffArray.size();
            xPoints = new int[pointsCount];
            yPoints = new int[pointsCount];
            int point = 0;
            Iterator<FlipFlop> iter = ffArray.iterator();
            if (iter.hasNext()) {
                FlipFlop lastFF = iter.next();
                xPoints[point] = (int) (lastFF.getCenter().getX() * scale);
                yPoints[point++] = (int) (lastFF.getCenter().getY() * scale);
                while (iter.hasNext()) {
                    FlipFlop ff = iter.next();
                    xPoints[point] = (int) (ff.getCenter().getX() * scale);
                    yPoints[point++] = (int) (ff.getCenter().getY() * scale);
                    lastFF = ff;
                }
            }
        } else {
            pointsCount = ffArray.size() * 2 - 1;
            xPoints = new int[pointsCount];
            yPoints = new int[pointsCount];
            int point = 0;
            Iterator<FlipFlop> iter = ffArray.iterator();
            if (iter.hasNext()) {
                FlipFlop lastFF = iter.next();
                xPoints[point] = (int) (lastFF.getCenter().getX() * scale);
                yPoints[point++] = (int) (lastFF.getCenter().getY() * scale);
                while (iter.hasNext()) {
                    FlipFlop ff = iter.next();
                    xPoints[point] = (int) (ff.getCenter().getX() * scale);
                    yPoints[point++] = (int) (lastFF.getCenter().getY() * scale);
                    xPoints[point] = (int) (ff.getCenter().getX() * scale);
                    yPoints[point++] = (int) (ff.getCenter().getY() * scale);
                    lastFF = ff;
                }
            }
        }
        g.setColor(color);
        g.drawPolyline(xPoints, yPoints, pointsCount);
    }

    public double getLenght(){
        return getLenght(flipflops);
    }
    public double getLenghtOpt(){
        return getLenght(flipflopsOpt);
    }
    public double getLenght(ArrayList<FlipFlop> ff) {
        double lenght = 0.0;
        Point2D.Double p1, p2;
        Iterator<FlipFlop> iter = ff.iterator();
        if (iter.hasNext()) {
            p2 = iter.next().getCenter();
            if (jRadioEuclidean.isSelected()) {
                while (iter.hasNext()) {
                    p1 = p2;
                    p2 = iter.next().getCenter();
                    lenght += Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
                }
            } else {
                while (iter.hasNext()) {
                    p1 = p2;
                    p2 = iter.next().getCenter();
                    lenght += Math.abs(p1.x - p2.x) + Math.abs(p1.y - p2.y);
                }
            }
        }
        return lenght;
    }

    public Iterator<FlipFlop> getFFIterator(){
        return flipflops.iterator();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jLabelLenght = new javax.swing.JLabel();
        jRadioEuclidean = new javax.swing.JRadioButton();
        jRadioManhattan = new javax.swing.JRadioButton();
        button1 = new java.awt.Button();
        jCheckBox1 = new javax.swing.JCheckBox();
        jButtonOptimize = new javax.swing.JButton();
        jComboBoxOptimization = new javax.swing.JComboBox();
        jLabelOptimizedLen = new javax.swing.JLabel();
        jRadioButtonOriginal = new javax.swing.JRadioButton();
        jRadioButtonOptimized = new javax.swing.JRadioButton();
        jCheckBoxAutoOptimize = new javax.swing.JCheckBox();
        jButtonSaveChain = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jButtonSaveDistancesCSV = new javax.swing.JButton();

        setName("Form"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(tspopt.TSPoptApp.class).getContext().getResourceMap(Chain.class);
        jLabelLenght.setText(resourceMap.getString("jLabelLenght.text")); // NOI18N
        jLabelLenght.setName("jLabelLenght"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(tspopt.TSPoptApp.class).getContext().getActionMap(Chain.class, this);
        jRadioEuclidean.setAction(actionMap.get("lenghtMethodChanged")); // NOI18N
        buttonGroup1.add(jRadioEuclidean);
        jRadioEuclidean.setText(resourceMap.getString("jRadioEuclidean.text")); // NOI18N
        jRadioEuclidean.setName("jRadioEuclidean"); // NOI18N

        jRadioManhattan.setAction(actionMap.get("lenghtMethodChanged")); // NOI18N
        buttonGroup1.add(jRadioManhattan);
        jRadioManhattan.setSelected(true);
        jRadioManhattan.setText(resourceMap.getString("jRadioManhattan.text")); // NOI18N
        jRadioManhattan.setName("jRadioManhattan"); // NOI18N

        button1.setLabel(resourceMap.getString("button1.label")); // NOI18N
        button1.setName("button1"); // NOI18N
        button1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                button1ActionPerformed(evt);
            }
        });

        jCheckBox1.setAction(actionMap.get("visibleChanged")); // NOI18N
        jCheckBox1.setSelected(true);
        jCheckBox1.setText(resourceMap.getString("jCheckBox1.text")); // NOI18N
        jCheckBox1.setName("jCheckBox1"); // NOI18N

        jButtonOptimize.setAction(actionMap.get("optimize2opt")); // NOI18N
        jButtonOptimize.setText(resourceMap.getString("jButtonOptimize.text")); // NOI18N
        jButtonOptimize.setName("jButtonOptimize"); // NOI18N
        jButtonOptimize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOptimizeActionPerformed(evt);
            }
        });

        jComboBoxOptimization.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "greedy", "2opt", "concorde" }));
        jComboBoxOptimization.setName("jComboBoxOptimization"); // NOI18N
        jComboBoxOptimization.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxOptimizationActionPerformed(evt);
            }
        });

        jLabelOptimizedLen.setText(resourceMap.getString("jLabelOptimizedLen.text")); // NOI18N
        jLabelOptimizedLen.setName("jLabelOptimizedLen"); // NOI18N

        buttonGroup2.add(jRadioButtonOriginal);
        jRadioButtonOriginal.setSelected(true);
        jRadioButtonOriginal.setText(resourceMap.getString("jRadioButtonOriginal.text")); // NOI18N
        jRadioButtonOriginal.setName("jRadioButtonOriginal"); // NOI18N
        jRadioButtonOriginal.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButtonOriginalStateChanged(evt);
            }
        });

        buttonGroup2.add(jRadioButtonOptimized);
        jRadioButtonOptimized.setText(resourceMap.getString("jRadioButtonOptimized.text")); // NOI18N
        jRadioButtonOptimized.setName("jRadioButtonOptimized"); // NOI18N
        jRadioButtonOptimized.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButtonOptimizedStateChanged(evt);
            }
        });

        jCheckBoxAutoOptimize.setSelected(true);
        jCheckBoxAutoOptimize.setText(resourceMap.getString("jCheckBoxAutoOptimize.text")); // NOI18N
        jCheckBoxAutoOptimize.setName("jCheckBoxAutoOptimize"); // NOI18N
        jCheckBoxAutoOptimize.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBoxAutoOptimizeStateChanged(evt);
            }
        });

        jButtonSaveChain.setText(resourceMap.getString("jButtonSaveChain.text")); // NOI18N
        jButtonSaveChain.setName("jButtonSaveChain"); // NOI18N
        jButtonSaveChain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveChainActionPerformed(evt);
            }
        });

        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setName("jButton1"); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButtonSaveDistancesCSV.setText(resourceMap.getString("jButtonSaveDistancesCSV.text")); // NOI18N
        jButtonSaveDistancesCSV.setName("jButtonSaveDistancesCSV"); // NOI18N
        jButtonSaveDistancesCSV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveDistancesCSVActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jRadioButtonOriginal)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonOptimized)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 226, Short.MAX_VALUE)
                        .addComponent(jButton1))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jRadioEuclidean)
                            .addComponent(jLabelLenght)
                            .addComponent(jRadioManhattan)
                            .addComponent(jCheckBox1)
                            .addComponent(jLabelOptimizedLen))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 197, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(button1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jComboBoxOptimization, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonOptimize))
                            .addComponent(jCheckBoxAutoOptimize)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButtonSaveDistancesCSV)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonSaveChain)))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabelLenght)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jRadioEuclidean)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioManhattan)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jCheckBox1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabelOptimizedLen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jRadioButtonOriginal)
                            .addComponent(jRadioButtonOptimized)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(button1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButtonOptimize)
                            .addComponent(jComboBoxOptimization, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jCheckBoxAutoOptimize)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButtonSaveChain)
                            .addComponent(jButtonSaveDistancesCSV))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)))
                .addContainerGap(24, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void button1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_button1ActionPerformed
        Color c = JColorChooser.showDialog(null, "Choose chain color", color);
        if (c != null){
            color = c;
            button1.setBackground(c);
            visPanel.repaint();
        }
    }

    @Action
    public void lenghtMethodChanged() {
        setLenghtLabel(getLenght());
        for (Iterator<FlipFlop> iter = flipflops.iterator(); iter.hasNext();){
                iter.next().setManhattan(jRadioManhattan.isSelected());
        }
        if (autoOptimize) jButtonOptimizeActionPerformed(null);
        visPanel.repaint();
    }//GEN-LAST:event_button1ActionPerformed

    private void jCheckBoxAutoOptimizeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBoxAutoOptimizeStateChanged
        autoOptimize = jCheckBoxAutoOptimize.isSelected();
        jButtonOptimize.setEnabled(!autoOptimize);
    }//GEN-LAST:event_jCheckBoxAutoOptimizeStateChanged

    private void jComboBoxOptimizationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxOptimizationActionPerformed
        String methodStr = (String)jComboBoxOptimization.getSelectedItem();
        if (autoOptimize) jButtonOptimizeActionPerformed(evt);
    }//GEN-LAST:event_jComboBoxOptimizationActionPerformed

    private void jButtonOptimizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOptimizeActionPerformed
        flipflopsOpt = (ArrayList<FlipFlop>) flipflops.clone();

        String methodStr = (String) jComboBoxOptimization.getSelectedItem();
        System.out.print("Running "+methodStr);
        if (jRadioEuclidean.isSelected())
            System.out.print(" euclidean norm...");
        else
            System.out.print(" manhattan norm...");

        long time1 = System.currentTimeMillis();
        if (methodStr.equals("2opt")) {           
            optimize2opt();
        }
        if (methodStr.equals("greedy")) {
            optimizeGreedy();
        }
        if (methodStr.equals("concorde")) {
            optimizeConcorde();
        }
        long time2 = System.currentTimeMillis();
        System.out.println("DONE");
        System.out.println("Computation time: "+Long.toString(time2-time1)+" ms");
        visPanel.repaint();
        Double len = getLenghtOpt();
        System.out.println("Optimized lenght: "+Double.toString(len));
        setOptLenghtLabel(len);
    }//GEN-LAST:event_jButtonOptimizeActionPerformed

    private void jRadioButtonOriginalStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButtonOriginalStateChanged
        if (autoOptimize) jButtonOptimizeActionPerformed(null);
    }//GEN-LAST:event_jRadioButtonOriginalStateChanged

    private void jRadioButtonOptimizedStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButtonOptimizedStateChanged
        if (autoOptimize) jButtonOptimizeActionPerformed(null);
    }//GEN-LAST:event_jRadioButtonOptimizedStateChanged

    private void jButtonSaveChainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveChainActionPerformed
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save chain");
        if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            saveTcl(fc.getSelectedFile().getPath());
        }
        /*String testname = (String) JOptionPane.showInputDialog(this, "Enter test name", "Test name", JOptionPane.QUESTION_MESSAGE);

        jRadioEuclidean.setSelected(true);
        jRadioManhattan.setSelected(false);
        jComboBoxOptimization.setSelectedIndex(0);
        lenghtMethodChanged();
        jButtonOptimizeActionPerformed(evt);
        saveTcl("/home/bartos/aaa/test_"+testname+"_chain_"+this.getName()+"_GE.tcl");
        jRadioEuclidean.setSelected(false);
        jRadioManhattan.setSelected(true);
        jComboBoxOptimization.setSelectedIndex(0);
        lenghtMethodChanged();
        jButtonOptimizeActionPerformed(evt);
        saveTcl("/home/bartos/aaa/test_"+testname+"_chain_"+this.getName()+"_GM.tcl");
        jRadioEuclidean.setSelected(true);
        jRadioManhattan.setSelected(false);
        jComboBoxOptimization.setSelectedIndex(1);
        lenghtMethodChanged();
        jButtonOptimizeActionPerformed(evt);
        saveTcl("/home/bartos/aaa/test_"+testname+"_chain_"+this.getName()+"_2OE.tcl");
        jRadioEuclidean.setSelected(false);
        jRadioManhattan.setSelected(true);
        jComboBoxOptimization.setSelectedIndex(1);
        lenghtMethodChanged();
        jButtonOptimizeActionPerformed(evt);
        saveTcl("/home/bartos/aaa/test_"+testname+"_chain_"+this.getName()+"_2OM.tcl");
        jRadioEuclidean.setSelected(true);
        jRadioManhattan.setSelected(false);
        jComboBoxOptimization.setSelectedIndex(2);
        lenghtMethodChanged();
        jButtonOptimizeActionPerformed(evt);
        saveTcl("/home/bartos/aaa/test_"+testname+"_chain_"+this.getName()+"_ConcordeE.tcl");
        jRadioEuclidean.setSelected(false);
        jRadioManhattan.setSelected(true);
        jComboBoxOptimization.setSelectedIndex(2);
        lenghtMethodChanged();
        jButtonOptimizeActionPerformed(evt);
        saveTcl("/home/bartos/aaa/test_"+testname+"_chain_"+this.getName()+"_ConcordeM.tcl");*/
    }//GEN-LAST:event_jButtonSaveChainActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        try {
            BufferedWriter fChain = new BufferedWriter(new FileWriter("f:/chain.qs"));
            fChain.write(String.valueOf(flipflopsOpt.size()));
            fChain.write(" 0\n");
            Iterator<FlipFlop> iter = flipflopsOpt.iterator();
            while (iter.hasNext()) {
                FlipFlop ff = iter.next();
                fChain.write(String.valueOf(ff.getCenter().getX()));
                fChain.write(" ");
                fChain.write(String.valueOf(ff.getCenter().getY()));
                fChain.write("\n");
            }
            fChain.close();

        } catch (IOException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        }

    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButtonSaveDistancesCSVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveDistancesCSVActionPerformed
        BufferedWriter fChain = null;
        JFileChooser fc = new JFileChooser();
        try {

            fc.setDialogTitle("original");
            if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                fChain = new BufferedWriter(new FileWriter(fc.getSelectedFile()));
                Iterator<FlipFlop> iter = flipflops.iterator();
                FlipFlop ffLast = iter.next();
                while (iter.hasNext()) {
                    FlipFlop ffNext = iter.next();
                    fChain.write(ffLast.getPath());
                    fChain.write(";");
                    fChain.write(ffNext.getPath());
                    fChain.write(";");
                    fChain.write(String.valueOf(ffLast.distanceFrom(ffNext)));
                    fChain.write("\n");
                    ffLast = ffNext;
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                fChain.close();
            } catch (IOException ex) {
                Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            fc.setDialogTitle("optimized");
            if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                fChain = new BufferedWriter(new FileWriter(fc.getSelectedFile()));
                Iterator<FlipFlop> iter = flipflopsOpt.iterator();
                FlipFlop ffLast = iter.next();
                while (iter.hasNext()) {
                    FlipFlop ffNext = iter.next();
                    fChain.write(ffLast.getPath());
                    fChain.write(";");
                    fChain.write(ffNext.getPath());
                    fChain.write(";");
                    fChain.write(String.valueOf(ffLast.distanceFrom(ffNext)));
                    fChain.write("\n");
                    ffLast = ffNext;
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                fChain.close();
            } catch (IOException ex) {
                Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }//GEN-LAST:event_jButtonSaveDistancesCSVActionPerformed

    public void saveTcl(String filename) {
        BufferedWriter fChain = null;
        try {
            fChain = new BufferedWriter(new FileWriter(filename));
            fChain.write("set_scan_path " + this.getName() + " -dedicated_scan_out false { \\\n");
            Iterator<FlipFlop> iter = flipflopsOpt.iterator();
            while (iter.hasNext()) {
                FlipFlop ff = iter.next();
                fChain.write("  \"");
                fChain.write(ff.getPath());
                fChain.write("\" \\\n");
            }
            fChain.write("}\n");
            fChain.close();
        } catch (IOException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                fChain.close();
            } catch (IOException ex) {
                Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Action
    public void visibleChanged() {
        visible = jCheckBox1.isSelected();
        visPanel.repaint();
    }

    @Action
    public void optimize2opt() {
        boolean done = false;
        int count = flipflopsOpt.size();
        for (int k=0; k < count && !done; k++){
            done = true;
            for (int i=0; i < count; i++){
                for (int j=i+2; j < count; j++){
                    if (
                            flipflopsOpt.get(i).distanceFrom(flipflopsOpt.get((i+1)%count)) + flipflopsOpt.get(j).distanceFrom(flipflopsOpt.get((j+1)%count))
                            >
                            flipflopsOpt.get(i).distanceFrom(flipflopsOpt.get(j)) + flipflopsOpt.get((i+1)%count).distanceFrom(flipflopsOpt.get((j+1)%count))
                       ){
                        FlipFlop tmp = flipflopsOpt.get((i+1)%count);
                        flipflopsOpt.set((i+1)%count, flipflopsOpt.get(j));
                        flipflopsOpt.set(j, tmp);
                        reverse(i+2, j-1);
                        done = false;
                    }
                }
            }
        }
    }

    private void reverse(int startIndex, int stopIndex) {
        if (startIndex >= stopIndex || startIndex >= flipflopsOpt.size() || stopIndex < 0) {
            return;
        }
        for (; startIndex < stopIndex; stopIndex--) {
            FlipFlop tmp = flipflopsOpt.get(startIndex);
            flipflopsOpt.set(startIndex, flipflopsOpt.get(stopIndex));
            flipflopsOpt.set(stopIndex, tmp);
            startIndex++;
        }
    }

    public void optimizeGreedy(){
        ArrayList<FlipFlop> ffCopy = (ArrayList<FlipFlop>) flipflops.clone();
        FlipFlop lastFF = ffCopy.get(0);
        flipflopsOpt.clear();
        flipflopsOpt.add(lastFF);
        ffCopy.remove(0);

        while (!ffCopy.isEmpty()){
            lastFF = findClosestFF(ffCopy, lastFF);
            flipflopsOpt.add(lastFF);
            ffCopy.remove(lastFF);
        }
    }
    private FlipFlop findClosestFF(ArrayList<FlipFlop> ffArray, FlipFlop ff){
        double min = Double.MAX_VALUE;
        FlipFlop closest = null;
        Iterator<FlipFlop> iter = ffArray.iterator();
        while(iter.hasNext()){
            FlipFlop ffNext = iter.next();
            if(ff == ffNext) continue;
            double dist = ff.distanceFrom(ffNext);
            if (dist < min){
                min = dist;
                closest = ffNext;
            }
        }
        return closest;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button button1;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButtonOptimize;
    private javax.swing.JButton jButtonSaveChain;
    private javax.swing.JButton jButtonSaveDistancesCSV;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JCheckBox jCheckBoxAutoOptimize;
    private javax.swing.JComboBox jComboBoxOptimization;
    private javax.swing.JLabel jLabelLenght;
    private javax.swing.JLabel jLabelOptimizedLen;
    private javax.swing.JRadioButton jRadioButtonOptimized;
    private javax.swing.JRadioButton jRadioButtonOriginal;
    private javax.swing.JRadioButton jRadioEuclidean;
    private javax.swing.JRadioButton jRadioManhattan;
    // End of variables declaration//GEN-END:variables

    private void optimizeConcorde() {
        String filename = "/home/bartos/concorde_tmp"+this.getName()+String.valueOf(flipflopsOpt.size())+".tsp";
        BufferedWriter fChain = null;
        try {
            fChain = new BufferedWriter(new FileWriter(filename));
            fChain.write("NAME : chain"+this.getName()+"\n");
            fChain.write("TYPE : TSP\n");
            fChain.write("COMMENT : "+filename+"\n");
            fChain.write("DIMENSION : "+String.valueOf(flipflopsOpt.size())+"\n");
            if (jRadioEuclidean.isSelected()){
                fChain.write("EDGE_WEIGHT_TYPE : EUC_2D\n");
            } else {
                fChain.write("EDGE_WEIGHT_TYPE : MAN_2D\n");
            }
//            fChain.write("EDGE_WEIGHT_TYPE : EXPLICIT\n");
//            fChain.write("EDGE_WEIGHT_FORMAT : FULL_MATRIX\n");
            //fChain.write("NODE_COORD_TYPE : TWOD_COORDS\n");
            fChain.write("NODE_COORD_SECTION\n");

            //DecimalFormat df = new DecimalFormat("#.##");
            //df.applyLocalizedPattern("#.##");

            Iterator<FlipFlop> iter = flipflopsOpt.iterator();
            int i=0;
            while (iter.hasNext()) {
                FlipFlop ff = iter.next();
                fChain.write(String.valueOf(i)+" "+Double.toString(ff.getCenter().getX()) +" "+Double.toString(ff.getCenter().getY())+"\n");
                //String str = String.valueOf(i)+" "+df.format(ff.getCenter().getX()) +" "+df.format(ff.getCenter().getY())+"\n";
                //str.replace(',', '.');
                //fChain.write(str);
                i++;
            }
  /*          fChain.write("EDGE_WEIGHT_SECTION\n");
            for (i=0; i < flipflopsOpt.size(); i++){
                for (int j=0; j<flipflopsOpt.size(); j++){
                    fChain.write(Double.toString(flipflopsOpt.get(i).distanceFrom(flipflopsOpt.get(j)))+" ");
                }
                fChain.write("\n");
            }
*/


            fChain.write("EOF\n");
            fChain.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        }

        Runtime rt = Runtime.getRuntime();
        try {
            System.out.print("Running concorde...");
            PrintStream out = System.out;
            Process p = rt.exec("/home/bartos/concorde -x -o " + filename + ".out " + filename);
            InputStream in = p.getInputStream();
            //System.setOut(new PrintStream(p.getInputStream()));
            while (true) {
                int c = in.read();
                if (c == -1) break;
                System.out.write((char)c);
            }
            p.waitFor();
            p.destroy();
            
            System.out.println("DONE");
        } catch (InterruptedException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        }

        try {
            File file = new File(filename + ".out");
            Scanner sc = new Scanner(file);
            int count = sc.nextInt();
            if (count != flipflopsOpt.size()) {
                System.out.print("neni stejny pocet mest ve vysledku");
                return;
            }

            ArrayList<FlipFlop> ffNew = new ArrayList<FlipFlop>();
            while (sc.hasNextInt()) {
                ffNew.add(flipflopsOpt.get(sc.nextInt()));
            }
            flipflopsOpt = ffNew;

            sc.close();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getRowCount() {
        return flipflops.size();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int i) {
        String[] colNames = {"Number", "Path", "A/D", "D/A"};
        return colNames[i];
    }

    public Class<?> getColumnClass(int i) {
        Class<?>[] classes = {Integer.class, String.class, Boolean.class, Boolean.class};
        return classes[i];
    }

    public boolean isCellEditable(int i, int i1) {
        return (i1 == 2 || i1 == 3);
    }

    public Object getValueAt(int i, int i1) {
        FlipFlop ff = flipflops.get(i);
        switch (i1){
            case 0: return ff.getCell();
            case 1: return ff.getPath();
            case 2: return ff.isAd();
            case 3: return ff.isDa();
            default: return null;
        }
    }

    public void setValueAt(Object o, int i, int i1) {
        FlipFlop ff = flipflops.get(i);
        if (o.getClass() != getColumnClass(i1)) return;
        switch (i1){
            case 2: ff.setAd((Boolean)o); break;
            case 3: ff.setDa((Boolean)o); break;
            default: break;
        }
    }

    public void addTableModelListener(TableModelListener tl) {
        tableListeners.add(tl);
    }

    public void removeTableModelListener(TableModelListener tl) {
        tableListeners.remove(tl);
    }

}
