/* 
 * File:   sky.cpp
 * Author: onin
 * 
 * Created on 30. duben 2009, 9:03
 */

#include <opencv/cxcore.h>
#include <opencv/cxtypes.h>

#include "sky.h"

namespace areaClsf {

	/**
	 * Default constructor.
	 */
	Sky::Sky ()
	{
	}

	/**
	 * Copy constructor.
	 */
	Sky::Sky (const Sky& orig)
	{
	}

	/**
	 * Destructor.
	 */
	Sky::~Sky ()
	{
	}

	/**
	 *
	 */
	TMapProbab Sky::Find (IplImage *orig, IplImage *seg)
	{
		// convert image to YUV color space
		IplImage *yuv = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 3);
		cvCvtColor(orig, yuv, CV_BGR2YCrCb);
		// split respective channels
		IplImage *yChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *uChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *vChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		cvSplit(yuv, yChnl, uChnl, vChnl, NULL);

		IplImage *tmpProb = static_cast<IplImage*>(cvClone(orig));//erase

		// maps for sum of sky occurence probability and count of pixels in each segment
		std::map<double, float> sum, count;

		// prepare images of absolute differences for texture probability computation
		// NOTE: could be optimized as integral images of AD
		IplImage *imgADhor = cvCreateImage(cvSize(seg->width-1, seg->height), IPL_DEPTH_8U, 1);
		for (int y = 0; y < imgADhor->height; y++) {
			for (int x = 0; x < imgADhor->width; x++) {
				(imgADhor->imageData + imgADhor->widthStep*y)[x] = static_cast<uchar>(fabs((yChnl->imageData + yChnl->widthStep*y)[x] - (yChnl->imageData + yChnl->widthStep*y)[x+1]));
			}
		}
		IplImage *imgADver = cvCreateImage(cvSize(seg->width, seg->height-1), IPL_DEPTH_8U, 1);
		for (int y = 0; y < imgADver->height; y++) {
			for (int x = 0; x < imgADver->width; x++) {
				(imgADver->imageData + imgADver->widthStep*y)[x] = static_cast<uchar>(fabs((yChnl->imageData + yChnl->widthStep*y)[x] - (yChnl->imageData + yChnl->widthStep*(y+1))[x]));
			}
		}

		// for each pixel do
		for (int y = 0; y < seg->height; y++) {
			for (int x = 0; x < seg->width; x++) {
				// algorithm from http://vca.ele.tue.nl/publications/data/Zafarifar2006b.pdf

				// color probability
				float pColorThreshold = 0.02;
				const uchar y0 = 255;
				const float sigmaY = 128.0;
				const uchar u0 = 70;
				const float sigmaU = 90.0;
				const uchar v0 = 170;
				const float sigmaV = 70.0;
				uchar yComponent = (yChnl->imageData + yChnl->widthStep*y)[x];
				uchar uComponent = (uChnl->imageData + uChnl->widthStep*y)[x];
				uchar vComponent = (vChnl->imageData + vChnl->widthStep*y)[x];
				float pColor = exp(-(pow((yComponent-y0) / sigmaY, 2) + pow((uComponent-u0) / sigmaU, 4) + pow((vComponent-v0) / sigmaV, 4)));
				pColor = pColor < pColorThreshold ? 0.0 : pColor;

				// texture probability (are there no gradients?)
				float pTextureThreshold = 64.0;
				float noiseThreshold = 0;
				// compute horizontal Sum of Absolute Differences
				float horSAD = 0;
				for (int wy = y-2; wy <= y+2; wy++) {
					for (int wx = x-2; wx < x+2; wx++) {
						horSAD += (imgADhor->imageData + imgADhor->widthStep*((imgADhor->height+wy)%imgADhor->height))[(imgADhor->width+wx)%imgADhor->width];
					}
				}
				horSAD /= 25;
				// compute vertical Sum of Absolute Differences
				float verSAD = 0;
				for (int wy = y-2; wy < y+2; wy++) {
					for (int wx = x-2; wx <= x+2; wx++) {
						verSAD += (imgADver->imageData + imgADver->widthStep*((imgADver->height+wy)%imgADver->height))[(imgADver->width+wx)%imgADver->width];
					}
				}
				verSAD /= 25;
				// compute probability of Sum of Absolute Differences
				float pSAD = exp(-pow(horSAD + verSAD - noiseThreshold, 2));
				// TODO: compute gradient probability
				float pGrad = 1;
				// overall sky texture probability
				float pTexture = pSAD * pGrad;
				//pTexture = pTexture > pTextureThreshold ? 0.0 : pTexture;
				//std::cout<< pTexture << std::endl;//erase

				// position probability (is it at the top?)
				float pPosition = exp(-pow(y / (0.4*seg->height), 2));

				// overall sky probability
				float pOverall = pPosition * pColor * pTexture;

				// save the probability
				double color = cvGet2D(seg, y, x).val[0];

				sum[color] += pOverall;
				count[color] ++;
				(tmpProb->imageData + tmpProb->widthStep*y)[3*x] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+1] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+2] = (int)(255 * pOverall);//erase

			}
		}

		// release auxiliary images
		cvReleaseImage(&imgADhor);
		cvReleaseImage(&imgADver);
		cvReleaseImage(&yChnl);
		cvReleaseImage(&uChnl);
		cvReleaseImage(&vChnl);
		cvReleaseImage(&yuv);

#if(DEBUG)
		//cvShowImage("resultWin", tmpProb); cvWaitKey(0);//erase
		cvSaveImage(this->frameName.c_str(), tmpProb);
#endif

		cvReleaseImage(&tmpProb);

		TMapProbab probabs;
		for (std::map<double, float>::iterator i = sum.begin(); i != sum.end(); ++i) {
			probabs[i->first] = sum[i->first] / count[i->first];
			//std::cout << int(i->first) << ": " << sum[i->first] << " - " << count[i->first] << std::endl;//erase
		}

		return probabs;
	}

}//namespace areaClsf
