/* 
 * File:   area.h
 * Author: onin
 *
 * Created on 27. duben 2009, 22:50
 */

#ifndef _AREA_H
#define	_AREA_H

#include <string>
#include <map>
#include <opencv/cv.h>
#include "../config.h"
#include "../debug.h"

namespace areaClsf {

	//<editor-fold defaultstate="collapsed" desc="Typedefs">
	typedef std::map<double, float> TMapProbab;
	//</editor-fold>
	;//semicolor here because of Netbeans code folding bug
	//<editor-fold defaultstate="collapsed" desc="BadAreaException">
	/**
	 * Thrown when area-type unknown to Area class is referenced.
	 */
	class BadAreaException: public std::exception
	{
		public:
			BadAreaException (EArea area) throw ();
			virtual ~BadAreaException () throw ();
			virtual const char* what() const throw ();

		private:
			EArea area;
	};
	//</editor-fold>

	/**
	 * Abstract class making parent for all factual area-types classes.
	 * Method find is obligatory.
	 */
	class Area {
		public:
			Area ();
			Area (const Area& orig);
			virtual ~Area ();
			/**
			 * Virtual method which has to be implemented in child classes.
			 * Must return a map of type TMapProbab, where key = (uchar) segment color,
			 * value = (float) probability that given segment is area of given type.
			 */
			virtual TMapProbab Find (IplImage *orig, IplImage *seg) = 0;
			static Area* GetNewArea (EArea areaType) throw (BadAreaException);
			std::string frameName;//erase

		private:

	};

}//namespace areaClsf

#endif	/* _AREA_H */

