/* 
 * File:   area.cpp
 * Author: onin
 * 
 * Created on 27. duben 2009, 22:50
 */

#include "area.h"
#include "grass.h"
#include "sky.h"
#include "pavement.h"
#include "water.h"
#include "fire.h"

namespace areaClsf {

	//<editor-fold defaultstate="collapsed" desc="BadAreaException">
	/**
	 * Constructor.
	 * @param areaName Name of unsupported area-type
	 */
	BadAreaException::BadAreaException (EArea area) throw ()
	{
		this->area = area;
	}

	/**
	 * Destructor.
	 */
	BadAreaException::~BadAreaException () throw ()
	{
	}

	/**
	 * Explanatory method.
	 * @return Explanation string
	 */
	const char* BadAreaException::what() const throw ()
	{
		return (std::string("Area named ") + Config::GetAreaName(this->area) + std::string(" is not supported by Area class.")).c_str();
	}
	//</editor-fold>

	/**
	 * Default constructor.
	 */
	Area::Area ()
	{
	}

	/**
	 * Copy constructor.
	 */
	Area::Area (const Area& orig)
	{
	}

	/**
	 * Destructor.
	 */
	Area::~Area ()
	{
	}

	/**
	 * Static method returning instance of factual area-type child class.
	 * @param areaType Number of desidred area-type
	 * @return Pointer to created area-type instance
	 * @throw BadAreaException When areaType is unsupported
	 */
	Area* Area::GetNewArea (EArea areaType) throw (BadAreaException)
	{
		if (areaType == A_GRASS) {
			return new Grass();
		} else if (areaType == A_SKY) {
			return new Sky();
		} else if (areaType == A_PVMT) {
			return new Pavement();
		} else if (areaType == A_WATER) {
			return new Water();
		} else if (areaType == A_FIRE) {
			return new Fire();
		} else {
			throw (BadAreaException(areaType));
		}
	}

}//namespace areaClsf
