
#ifndef __ATOMIC_H
#define __ATOMIC_H

@begin
   include "basic.h"
@end

/*
 * definition of structure atomic_s
 */

@begin
   define atomic_s static
@end

struct atomic_s
{
   int counter;

   inline void init() {}
   inline void clear() {}

   inline void swap(atomic_s &a_second) {cassert(0);}
   inline atomic_s &operator=(atomic_s &a_src) {cassert(0); return *this;}
   inline bool operator==(atomic_s &a_second) {cassert(0); return false;}

   /*!
    * \brief set atomic variable to given value
    */
   inline void atomic_set(int a_value);

   /*!
    * \brief increase atomic variable by one
    */
   inline void atomic_inc();

   /*!
    * \brief decrease atomic variable by one
    */
   inline void atomic_dec();

   /*!
    * \brief add value to atomic variable
    */
   inline void atomic_add(int a_value);

   /*!
    * \brief decrease atomic variable by one and return 1 if new value is equal to 0
    */
   inline int atomic_dec_and_test();
};

/*
 * inline methods od structure atomic_s
 */

inline void atomic_s::atomic_set(int a_value)
{/*{{{*/
   counter = a_value;
}/*}}}*/

inline void atomic_s::atomic_inc()
{/*{{{*/
#if ATOMIC_TYPE == ATOMIC_TYPE_GCC
   __sync_add_and_fetch(&counter,1);
#else
      counter++;
#endif
}/*}}}*/

inline void atomic_s::atomic_dec()
{/*{{{*/
#if ATOMIC_TYPE == ATOMIC_TYPE_GCC
   __sync_sub_and_fetch(&counter,1);
#else
   counter--;
#endif
}/*}}}*/

inline void atomic_s::atomic_add(int a_value)
{/*{{{*/
#if ATOMIC_TYPE == ATOMIC_TYPE_GCC
   __sync_add_and_fetch(&counter,a_value);
#else
   counter += a_value;
#endif
}/*}}}*/

inline int atomic_s::atomic_dec_and_test()
{/*{{{*/
#if ATOMIC_TYPE == ATOMIC_TYPE_GCC
   return __sync_sub_and_fetch(&counter,1) == 0;
#else
   return (--counter == 0);
#endif
}/*}}}*/

#endif

