
#ifndef __THREAD_H
#define __THREAD_H

@begin
   include "basic.h"
@end

/*
 * definition of structure thread_s
 */

@begin
   define thread_s dynamic
@end

struct thread_s
{
#if THREAD_LIB == THREAD_LIB_PTHREAD
   pthread_t thread;
#endif

   inline void init() {}
   inline void clear() {}
   inline void flush_all() {}
   inline void swap(thread_s &a_second) {cassert(0);}
   inline thread_s &operator=(thread_s &a_src) {cassert(0); return *this;}
   inline bool operator==(thread_s &a_second) {cassert(0); return false;}

   /*!
    * \brief execute new thread at function with given parameters
    * \return error code
    */
   inline unsigned create(void *a_thread_fuction,void *a_parameters);

   /*!
    * \brief create thread_s for existing (self) thread
    */
#if THREAD_LIB == THREAD_LIB_PTHREAD
   inline void create_from_actual(pthread_t a_thread);
#endif

   /*!
    * \brief join thread to actual (self) thread
    */
   inline unsigned join(void **a_return_ptr);

   /*!
    * \brief detach thread
    * \return error code
    */
   inline unsigned detach();

   /*!
    * \brief break running of actual thread, until it is newly scheduled for execution
    * \return error code
    */
   inline static unsigned yield();
};

/*
 * inline methods of structure thread_s
 */

inline unsigned thread_s::create(void *a_thread_function,void *a_parameters)
{/*{{{*/
#if THREAD_LIB == THREAD_LIB_PTHREAD
   int ret = pthread_create(&thread,NULL,(void *(*)(void *))a_thread_function,a_parameters);
   switch (ret) {
   case 0:
      return c_error_OK;
   case EAGAIN:
      return c_error_EAGAIN;
   case EINVAL:
      return c_error_EINVAL;
   default:
      return c_error_UNKNOWN;
   }
#else
   cassert(0);
   return c_error_UNKNOWN;
#endif
}/*}}}*/

#if THREAD_LIB == THREAD_LIB_PTHREAD
inline void thread_s::create_from_actual(pthread_t a_thread)
{/*{{{*/
   thread = a_thread;
}/*}}}*/
#endif

inline unsigned thread_s::join(void **a_return_ptr)
{/*{{{*/
#if THREAD_LIB == THREAD_LIB_PTHREAD
   int ret = pthread_join(thread,a_return_ptr);
   switch (ret) {
   case 0:
      return c_error_OK;
   case ESRCH:
      return c_error_ESRCH;
   case EINVAL:
      return c_error_EINVAL;
   case EDEADLK:
      return c_error_EDEADLK;
   default:
      return c_error_UNKNOWN;
   }
#else
   cassert(0);
   return c_error_UNKNOWN;
#endif
}/*}}}*/

inline unsigned thread_s::detach()
{/*{{{*/
#if THREAD_LIB == THREAD_LIB_PTHREAD
   int ret = pthread_detach(thread);
   switch (ret) {
   case 0:
      return c_error_OK;
   case ESRCH:
      return c_error_ESRCH;
   case EINVAL:
      return c_error_EINVAL;
   default:
      return c_error_UNKNOWN;
   }
#else
   cassert(0);
   return c_error_UNKNOWN;
#endif
}/*}}}*/

inline unsigned thread_s::yield() 
{/*{{{*/
#if THREAD_LIB == THREAD_LIB_PTHREAD

#ifdef __WIN32
   // FIXME - yield in windows
#else
   pthread_yield();
#endif

   return c_error_OK;
#else
   cassert(0);
   return c_error_UNKNOWN;
#endif
}/*}}}*/

#endif

