
@begin
   include "string.h"
@end

/*
 * methods of structure string_s
 */

// - trailing character of blank strings -
char c_string_terminating_char = '\0';

bool string_s::read_line_from_stream(FILE *a_stream)
{/*{{{*/
   clear();

   const unsigned c_buffer_size = 256;
   char buffer[c_buffer_size];

   if (fgets(buffer,c_buffer_size,a_stream) == NULL) {
      return false;
   }

   unsigned b_str_size = strlen(buffer) + 1;
   set(b_str_size - 1,buffer);

   if (buffer[b_str_size - 2] == '\n') {
      return true;
   }

   string_s tmp_str;
   tmp_str.init();

   do {
      if (fgets(buffer,c_buffer_size,a_stream) == NULL) {
	 break;
      }

      unsigned b_str_size = strlen(buffer) + 1;
      tmp_str.conc_set(size - 1,data,b_str_size - 1,buffer);
      swap(tmp_str);

      if (buffer[b_str_size - 2] == '\n') {
	 break;
      }
   } while(1);

   tmp_str.clear();

   return true;
}/*}}}*/

void string_s::setf(const char *a_format,...)
{/*{{{*/
   clear();

   const int init_size = 256;
   int alloc_size = init_size;

   va_list ap;

   do {
      data = (char *)cmalloc(alloc_size*sizeof(char));

      va_start(ap,a_format);
      int cnt = vsnprintf(data,alloc_size,a_format,ap);
      va_end(ap);

      if (cnt < alloc_size) {
	 size = cnt + 1;
	 break;
      }

      cfree(data);
      alloc_size <<= 1;

   } while(1);
}/*}}}*/

void string_s::concf(const char *a_format,...)
{/*{{{*/
   const int init_size = 256;
   int alloc_size = init_size;

   // - creation of formated string -
   string_s fmt_str;
   fmt_str.init();

   va_list ap;

   do {
      fmt_str.data = (char *)cmalloc(alloc_size*sizeof(char));

      va_start(ap,a_format);
      int cnt = vsnprintf(fmt_str.data,alloc_size,a_format,ap);
      va_end(ap);

      if (cnt < alloc_size) {
	 fmt_str.size = cnt + 1;
	 break;
      }

      cfree(fmt_str.data);
      alloc_size <<= 1;

   } while(1);

   // - concatenation to result string -
   string_s res_str;
   res_str.init();
   res_str.conc_set(size - 1,data,fmt_str.size - 1,fmt_str.data);

   // - swap this string with result string -
   swap(res_str);

   // - clear temporary strings -
   res_str.clear();
   fmt_str.clear();
}/*}}}*/

unsigned string_s::get_idx(unsigned a_idx,unsigned a_length,const char *a_data)
{/*{{{*/
   if (a_idx >= (size - 1) || a_length >= (size - a_idx)) {
      return c_idx_not_exist;
   }

   char *s_ptr = data + a_idx;
   char *s_ptr_end = data + (size - a_length);
   do {

      char *ss_ptr = s_ptr;
      char *ss_ptr_end = ss_ptr + a_length;
      const char *a_ptr = a_data;
      do {
	 if (*ss_ptr != *a_ptr) {
	    break;
	 }

	 if (++a_ptr,++ss_ptr >= ss_ptr_end) {
	    return s_ptr - data;
	 }
      } while(1);

   } while(++s_ptr < s_ptr_end);

   return c_idx_not_exist;
}/*}}}*/

unsigned string_s::get_character_line(unsigned a_c_idx)
{/*{{{*/
   if (size <= a_c_idx) return 0;

   char *c_ptr = data;
   char *c_ptr_end = c_ptr + a_c_idx;
   unsigned line_cnt = 1;

   do {
      if (*c_ptr == '\n') {
	 line_cnt++;
      }
   } while(++c_ptr < c_ptr_end);

   return line_cnt;
}/*}}}*/

unsigned string_s::get_character_line_begin(unsigned a_c_idx)
{/*{{{*/
   char *s_ptr = data + a_c_idx;

   do {
      if (*s_ptr == '\n') {
	 break;
      }
   } while(--s_ptr >= data);

   return s_ptr - data;
}/*}}}*/

unsigned string_s::get_character_line_end(unsigned a_c_idx)
{/*{{{*/
   char *e_ptr = data + a_c_idx;
   char *e_ptr_end = data + size;

   do {
      if (*e_ptr == '\n') {
	 break;
      }
   } while(++e_ptr < e_ptr_end);

   return e_ptr - data;
}/*}}}*/

/*
 * methods of generated structures
 */

// -- string_array_s --
@begin
   methods string_array_s
@end

