
@begin
   include "spec_seg.h"
@end

/*
 * methods of generated structures
 */

// -- ra_kernel_s --
@begin
   methods ra_kernel_s
@end

// -- ra_kernel_array_s --
@begin
   methods ra_kernel_array_s
@end

// -- spec_seg_s --
@begin
   methods spec_seg_s
@end

bool spec_seg_s::initialize_area_values()
{/*{{{*/
   if (block_power_size == 0 || (radial_cnt + angular_cnt) == 0 || (radial_cnt != 0 && radial == NULL) || (angular_cnt != 0 && angular == NULL)) {
      return false;
   }

//#define SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_RADIAL 1
//#define SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_ANGULAR 1

   // - clear ra_kernels -
   ra_kernel_array.clear();

   unsigned offset_step = c_pixel_sizes[c_image_pixel_format_2x64F];
   unsigned offset = 0;

   // - steps in x and y axes -
   float x_step = 1.0f/block_size;
   float y_step = 1.0f/block_size;

#if SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_RADIAL || SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_ANGULAR
   image_s img;
   img.init();
   img.create(block_size,block_size,c_image_pixel_format_2x64F);
   img.io_clear();
   unsigned char *img_ptr = img.image_data_ptr->data + img.y_pos*img.image_data_ptr->line_bytes + img.x_pos*img.pixel_step;
#endif

   // - compute ra_kernels -
   float y = -0.5f;
   do {
      float x = -0.5f;
      do {
         float distance = sqrtf(x*x + y*y);

         // - radial area features -
         if (radial_cnt > 0) {
            unsigned i_idx = 0;
            do {
               if (radial[i_idx << 1] <= distance && radial[(i_idx << 1) + 1] >= distance) {
                  ra_kernel_array.push_blank();
                  ra_kernel_array.last().set(offset,i_idx);

#if SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_RADIAL
                  *((double *)(img_ptr + offset)) = 1.0;
#endif
               }
            } while(++i_idx < radial_cnt);
         }

         // - angular area features -
         if (angular_cnt > 0) {
            unsigned i_idx = 0;
            do {
               
               // - compute angle -
               float angle;
               if (x > 0.0f) {
                  angle = atan(y/x);
               }
               else if (x < 0.0f) {
                  if (y >= 0.0f) {
                     angle = atan(y/x) + c_pi_number;
                  }
                  else {
                     angle = atan(y/x) - c_pi_number;
                  }
               }
               else {
                  if (y > 0.0f) {
                     angle = 0.5f*c_pi_number;
                  }
                  else if (y < 0.0f) {
                     angle = -0.5f*c_pi_number;
                  }
                  else {
                     continue;
                  }
               }

               // - compute invert angle -
               float invert_angle = angle + c_pi_number;
               if (invert_angle > c_pi_number) {
                  invert_angle -= c_2pi_number;
               }

               // - compute kernels -
               if ((angular[i_idx << 1] <= angle && angular[(i_idx << 1) + 1] >= angle) || 
                  (angular[i_idx << 1] <= invert_angle && angular[(i_idx << 1) + 1] >= invert_angle)) {

                  ra_kernel_array.push_blank();
                  ra_kernel_array.last().set(offset,radial_cnt + i_idx);

#if SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_ANGULAR
                  *((double *)(img_ptr + offset)) = 1.0;
#endif
               }

            } while(++i_idx < angular_cnt);
         }
      } while(offset += offset_step,(x += x_step) < 0.5f);
   } while((y += y_step) < 0.5f);

#if SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_RADIAL || SPEC_SEG_S_INITIALIZE_AREA_VALUES_RENDER_ANGULAR
   {
      image_s trg_img;

      image_s f_img;
      f_img.init();
      f_img.create(img.width,img.height,c_image_pixel_format_32F);
      f_img.io_convert(img);

      trg_img.init();
      trg_img.create(img.width,img.height,c_image_pixel_format_3x8U);

      trg_img.io_convert(f_img);
      trg_img.save_to_bmp_file("copy.bmp");

      f_img.clear();
      trg_img.clear();
   }

   img.clear();
#endif

   return true;
}/*}}}*/

bool spec_seg_s::compute_radial_and_angular_means(image_s &a_img,float *a_mean_vector)
{/*{{{*/
   // - clear mean vector -
   memset(a_mean_vector,0,length*sizeof(float));

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned char *image_data = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;

   // compute radial and angular sums
   if (ra_kernel_array.used != 0) {
      ra_kernel_s *k_ptr = ra_kernel_array.data;
      ra_kernel_s *k_ptr_end = k_ptr + ra_kernel_array.used;
      do {
         double *d_ptr = (double *)(image_data + k_ptr->offset);
         a_mean_vector[k_ptr->target] += d_ptr[0]*d_ptr[0] + d_ptr[1]*d_ptr[1];
      } while(++k_ptr < k_ptr_end);
   }

   return true;
}/*}}}*/

bool spec_seg_s::compute_spectral_features_data(image_s &a_img)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_2x64F || a_img.width < block_size || 
      a_img.height < block_size) {
      return false;
   }

   // - set width and height -
   width = a_img.width - (block_size - 1);
   height = a_img.height - (block_size - 1);
   length = radial_cnt + angular_cnt;

   // - clear seg_data -
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   // - create seg_data -
   unsigned sf_data_b_size = width*height*length*sizeof(float);
   seg_data = (float *)cmalloc(sf_data_b_size);

   // - crop image -
   image_s c_img;
   c_img.init();
   c_img.create(block_size,block_size,c_image_pixel_format_2x64F);

   // - reference image -
   image_s ref_img;
   ref_img.init();

   unsigned y_end = height;
   unsigned x_end = width;

   float *sf_ptr = seg_data;
   unsigned y = 0;
   do {
      unsigned x = 0;
      do {
         ref_img.create_referred(x,y,block_size,block_size,a_img);
         c_img.io_copy(ref_img);

         cassert(c_img.io_compute_fft(true,block_power_size,block_power_size));
         cassert(c_img.io_swap_quarters());

         compute_radial_and_angular_means(c_img,sf_ptr);
      } while(sf_ptr += length,++x < x_end);

      // FIXME print processed row
      fputc('.',stderr);

   } while(++y < y_end);

   ref_img.clear();
   c_img.clear();

   return true;
}/*}}}*/

void spec_seg_s::get_feature_parameters_string(string_s &a_fp_str)
{/*{{{*/
   a_fp_str.setf("block_power_size=%u radial_cnt=%u angular_cnt=%u",block_power_size,radial_cnt,angular_cnt);

   a_fp_str.concf(" radial=");

   if (radial_cnt > 0) {
      float *ptr = radial;
      float *ptr_end = ptr + (radial_cnt << 1);
      do {
         a_fp_str.concf("%f,",*ptr);
      } while(++ptr < ptr_end);
   }

   a_fp_str.concf(" angular=");

   if (angular_cnt > 0) {
      float *ptr = angular;
      float *ptr_end = ptr + (angular_cnt << 1);
      do {
         a_fp_str.concf("%f,",*ptr);
      } while(++ptr < ptr_end);
   }
}/*}}}*/

bool spec_seg_s::get_features_MASK(image_s &a_mask,feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_SPECTRAL_FEATURES;

   // - generate feature_parameters string -
   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = 0;
   a_fd.height = 0;

   kernel_info_s ki = {0,0,block_size,block_size};

   unsigned vector_cnt = extract_masked_vectors(seg_data,&a_fd.fv_data,a_mask,ki,length);
   if (vector_cnt == c_idx_not_exist) {
      if (a_fd.fv_data != NULL) {
         cfree(a_fd.fv_data);
         a_fd.fv_data = NULL;
      }
      return false;
   }

   a_fd.fv_cnt = vector_cnt;
   a_fd.fv_length = length;

   return true;
}/*}}}*/

