
@begin
   include "lm_seg.h"
@end

/*
 * methods of generated structures
 */

// -- lms_kernel_s --
@begin
   methods lms_kernel_s
@end

// -- lms_kernel_array_s --
@begin
   methods lms_kernel_array_s
@end

// -- lm_seg_s --
@begin
   methods lm_seg_s
@end

bool lm_seg_s::generate_convolution_kernels(image_s &a_img)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_32F || kernel_cnt == 0 || kernel_side_size == 0) {
      return false;
   }

   // - clear previously created lms_kernels -
   lms_kernels.clear();

   // - image parameters -
   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;

   // - create convolution lms_kernels -
   unsigned k_idx = 0;
   do {
      const float *k_ptr = kernels + k_idx*kernel_size;
      const float *k_ptr_end = k_ptr + kernel_size;
      unsigned offset = 0;
      do {
         const float *k_ptr_w_end = k_ptr + kernel_side_size;
         do {
            if (*k_ptr != 0.0f) {
               lms_kernels.push_blank();
               lms_kernel_s &kernel = lms_kernels.last();
               kernel.set(offset,k_idx,*k_ptr);
            }
         } while(offset += pixel_step,++k_ptr < k_ptr_w_end);

         offset += line_size - kernel_side_size*pixel_step;
      } while(k_ptr < k_ptr_end);
   } while(++k_idx < kernel_cnt);

   return true;
}/*}}}*/

bool lm_seg_s::compute_per_pixel_lm_data(image_s &a_img)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_32F || kernel_side_size > a_img.width || 
      kernel_side_size > a_img.height || lms_kernels.used == 0) {
      return false;
   }

   width = a_img.width - (kernel_side_size - 1);
   height = a_img.height - (kernel_side_size - 1);
   length = kernel_cnt;

   // - clear seg_data -
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   // - create seg_data -
   unsigned data_b_size = width*height*kernel_cnt*sizeof(float);
   seg_data = (float *)cmalloc(data_b_size);
   memset(seg_data,0,data_b_size);

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned image_ls = (a_img.width - (kernel_side_size - 1))*pixel_step;

   unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
   unsigned char *ptr_end = ptr + (a_img.height - (kernel_side_size - 1) - 1)*line_size + image_ls;
   float *d_ptr = seg_data;

   do {
      unsigned char *ptr_w_end = ptr + image_ls;
      do {
         lms_kernel_s *k_ptr = lms_kernels.data;
         lms_kernel_s *k_ptr_end = k_ptr + lms_kernels.used;
         do {
            *(d_ptr + k_ptr->trg_off) += *((float *)(ptr + k_ptr->src_off))*k_ptr->value;
         } while(++k_ptr < k_ptr_end);
      } while(d_ptr += kernel_cnt,(ptr += pixel_step) < ptr_w_end);

      ptr += line_size - image_ls;
   } while(ptr < ptr_end);

   return true;
}/*}}}*/

void lm_seg_s::get_feature_parameters_string(string_s &a_fp_str)
{/*{{{*/
   a_fp_str.setf("kernel_side_size=%u kernel_cnt=%u kernels=",kernel_side_size,kernel_cnt);

   if (kernel_cnt > 0) {
      float *ptr = kernels;
      float *ptr_end = ptr + kernel_cnt*kernel_size;

      if (ptr < ptr_end) {
         do {
            a_fp_str.concf("%f,",*ptr);
         } while(++ptr < ptr_end);
      }
   }
}/*}}}*/

bool lm_seg_s::get_features_MASK(image_s &a_mask,feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_LOCAL_MOMENTS_FEATURES;

   // - create feature_parameters string -
   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = 0;
   a_fd.height = 0;

   kernel_info_s ki = {0,0,kernel_side_size,kernel_side_size};

   unsigned vector_cnt = extract_masked_vectors(seg_data,&a_fd.fv_data,a_mask,ki,length);
   if (vector_cnt == c_idx_not_exist) {
      if (a_fd.fv_data != NULL) {
         cfree(a_fd.fv_data);
         a_fd.fv_data = NULL;
      }
      return false;
   }

   a_fd.fv_cnt = vector_cnt;
   a_fd.fv_length = length;

   return true;
}/*}}}*/

