
#ifndef __LBP_SEG_H
#define __LBP_SEG_H

@begin
   include "basic.h"
   include "mem_check.h"
   include "structures.h"
   include "atomic.h"
   include "bitmap.h"
   include "image.h"
   include "segmentation.h"
@end

/*
 * basic definition and constants
 */

/*
 * definition of generated structures
 */

// -- lbp_seg_s --
@begin
   struct
   <
   uc:lbp_blank
   unsigned:hist_size
   unsigned:hist_bf_b_size
   unsigned:block_size
   unsigned:block_size_m1
   unsigned:radius
   uc_ptr:minimal_value_map

   unsigned:width
   unsigned:height
   unsigned:length
   image_s:lbp_image
   bf_ptr:seg_data
   >

   not_generate: init clear

   additions {
      inline void init();
      inline void clear();
      inline bool setup(unsigned a_lbp_blank,unsigned a_hist_size,unsigned a_block_size,unsigned a_radius,const unsigned char *a_minimal_value_map);

      bool seg_lbp_compute_offset_and_multiplier_array(image_s &a_src,unsigned a_pattern_length,unsigned a_radius,ui_array_s &a_om_array);

      bool seg_lbp_compute_LBP_by_offset_and_mutiplier_array(image_s &a_src,image_s &a_trg,unsigned a_pattern_length,unsigned a_radius,ui_array_s &a_om_array);
      bool seg_lbp_compute_LBP(image_s &a_src,image_s &a_trg,unsigned a_pattern_length,unsigned a_radius);

      bool seg_lbp_compute_LBP_by_offset_and_mutiplier_array_with_intensity(image_s &a_src,image_s &a_trg,image_s &a_intensity,unsigned a_pattern_length,unsigned a_radius,ui_array_s &a_om_array);
      bool seg_lbp_compute_LBP_with_intensity(image_s &a_src,image_s &a_trg,image_s &a_intensity,unsigned a_pattern_length,unsigned a_radius);

      inline bool compute_lbp_values(image_s &a_img);

      bool compute_lbp_histograms();
      bool create_image_from_lbp_histograms(image_s &a_img);

      void get_feature_parameters_string(string_s &a_fp_str);
      inline bool get_features(feature_data_s &a_fd);
      bool get_features_MASK(image_s &a_mask,feature_data_s &a_fd);
   }

   lbp_seg_s;
@end

/*
 * inline methods of structure image_s
 */

// -- lbp_seg_s --
@begin
   inlines lbp_seg_s
@end

inline void lbp_seg_s::init()
{/*{{{*/
   minimal_value_map = NULL;

   lbp_image.init();
   seg_data = NULL;
}/*}}}*/

inline void lbp_seg_s::clear()
{/*{{{*/
   lbp_image.clear();

   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   init();
}/*}}}*/

inline bool lbp_seg_s::setup(unsigned a_lbp_blank,unsigned a_hist_size,unsigned a_block_size,unsigned a_radius,const unsigned char *a_minimal_value_map)
{/*{{{*/
   if (a_minimal_value_map == NULL) {
      return false;
   }

   lbp_blank = a_lbp_blank;
   hist_size = a_hist_size;
   hist_bf_b_size = hist_size*sizeof(float);
   block_size = a_block_size;
   block_size_m1 = block_size - 1;
   radius = a_radius;
   minimal_value_map = (unsigned char *)a_minimal_value_map;

   return true;
}/*}}}*/

inline bool lbp_seg_s::compute_lbp_values(image_s &a_img)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_8U || radius == 0 || minimal_value_map == NULL) {
      return false;
   }

   if (lbp_image.pixel_format != c_image_pixel_format_8U || a_img.width != lbp_image.width || a_img.height != lbp_image.height) {
      lbp_image.create(a_img);
      lbp_image.io_clear();
   }

   return seg_lbp_compute_LBP(a_img,lbp_image,8,radius);
}/*}}}*/

inline bool lbp_seg_s::get_features(feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_LBP_FEATURES;
   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = width;
   a_fd.height = height;
   a_fd.fv_cnt = width*height;
   a_fd.fv_length = length;
   a_fd.fv_data = seg_data;
   seg_data = NULL;

   return true;
}/*}}}*/

#endif

