
#ifndef __SEGMENTATION_H
#define __SEGMENTATION_H

@begin
   include "basic.h"
   include "mem_check.h"
   include "structures.h"
   include "atomic.h"
   include "bitmap.h"
   include "image.h"
@end

/*
 * basic definition and constants
 */

// - define float  pointer -
typedef float* bf_ptr;
@begin
   define bf_ptr basic
@end

// -- LOCAL MOMENT FEATURES --

const unsigned c_lm_kernel_side_size = 5;
const unsigned c_lm_kernel_size = c_lm_kernel_side_size*c_lm_kernel_side_size;
const unsigned c_lm_kernel_b_size = c_lm_kernel_size*sizeof(float);
const unsigned c_lm_kernel_cnt = 6;
const float c_lm_kernels[] = {
   
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f,-1.0f,-1.0f,-1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 0.0f,-1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
};

/*
 * definition of global functions
 */

/*
 * definition of generated structures
 */

// -- feature_vector_s --
@begin
   array<float> feature_vector_s;
@end

// -- feature_vectors_s --
@begin
   array<feature_vector_s> feature_vectors_s;
@end

// -- LOCAL MOMENT FEATURES --

// -- lms_kernel_s --
@begin
   struct
   <
   unsigned:src_off
   unsigned:trg_off
   float:value
   >
   lms_kernel_s;
@end

// -- lms_kernel_array_s --
@begin
   array<lms_kernel_s> lms_kernel_array_s;
@end

// -- lm_seg_s --
@begin
   struct
   <
   unsigned:width
   unsigned:height
   lms_kernel_array_s:kernels
   feature_vectors_s:feature_vectors
   >

   additions {
      bool generate_convolution_kernels(image_s &a_img);
      bool compute_per_pixel_lm_data(image_s &a_img);
   }

   lm_seg_s;
@end

/*
 * inline methods of structure image_s
 */

// -- feature_vector_s --
@begin
   inlines feature_vector_s
@end

// -- feature_vectors_s --
@begin
   inlines feature_vectors_s
@end

// -- LOCAL MOMENT FEATURES --

// -- lms_kernel_s --
@begin
   inlines lms_kernel_s
@end

// -- lms_kernel_array_s --
@begin
   inlines lms_kernel_array_s
@end

// -- lm_seg_s --
@begin
   inlines lm_seg_s
@end

#endif

